/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;

public class AbstractStyleVisitor
implements StyleVisitor {
    public void visit(StyledLayerDescriptor sld) {
        for (StyledLayer sl : sld.getStyledLayers()) {
            if (sl instanceof UserLayer) {
                ((UserLayer)sl).accept((StyleVisitor)this);
                continue;
            }
            if (!(sl instanceof NamedLayer)) continue;
            ((NamedLayer)sl).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        for (Style style : layer.getStyles()) {
            style.accept((StyleVisitor)this);
        }
        for (Style style : layer.getLayerFeatureConstraints()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        for (Style style : layer.getUserStyles()) {
            style.accept((StyleVisitor)this);
        }
        for (Style style : layer.getLayerFeatureConstraints()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(Style style) {
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            fts.accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        for (Symbolizer sym : rule.symbolizers()) {
            sym.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeStyle fts) {
        for (Rule r : fts.rules()) {
            r.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept((StyleVisitor)this);
        }
    }

    public void visit(Stroke stroke) {
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept((StyleVisitor)this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        } else if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        } else if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        } else if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        } else if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        } else {
            throw new RuntimeException("visit(Symbolizer) unsupported");
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getDescription() != null) {
            ps.getDescription().accept((StyleVisitor)this);
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getDescription() != null) {
            line.getDescription().accept((StyleVisitor)this);
        }
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getDescription() != null) {
            poly.getDescription().accept((StyleVisitor)this);
        }
        if (poly.getDisplacement() != null) {
            poly.getDisplacement().accept((StyleVisitor)this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept((StyleVisitor)this);
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text.getDescription() != null) {
            text.getDescription().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept((StyleVisitor)this);
        }
    }

    public void visit(RasterSymbolizer raster) {
        if (raster.getChannelSelection() != null) {
            raster.getChannelSelection().accept((StyleVisitor)this);
        }
        if (raster.getColorMap() != null) {
            raster.getColorMap().accept((StyleVisitor)this);
        }
        if (raster.getContrastEnhancement() != null) {
            raster.getContrastEnhancement().accept((StyleVisitor)this);
        }
        if (raster.getDescription() != null) {
            raster.getDescription().accept((StyleVisitor)this);
        }
        if (raster.getImageOutline() != null) {
            raster.getImageOutline().accept((StyleVisitor)this);
        }
        if (raster.getShadedRelief() != null) {
            raster.getShadedRelief().accept((StyleVisitor)this);
        }
    }

    public void visit(Graphic gr) {
        if (gr.getAnchorPoint() != null) {
            gr.getAnchorPoint().accept((StyleVisitor)this);
        }
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept((StyleVisitor)this);
        }
        for (GraphicalSymbol gs : gr.graphicalSymbols()) {
            if (gs instanceof Symbol) {
                gs.accept((StyleVisitor)this);
                continue;
            }
            throw new RuntimeException("Don't know how to visit " + gs);
        }
    }

    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept((StyleVisitor)this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept((StyleVisitor)this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept((StyleVisitor)this);
        }
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMap colorMap) {
        for (ColorMapEntry cme : colorMap.getColorMapEntries()) {
            cme.accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMapEntry colorMapEntry) {
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    public void visit(ImageOutline outline) {
        if (outline.getSymbolizer() != null) {
            outline.getSymbolizer().accept((StyleVisitor)this);
        }
    }

    public void visit(ChannelSelection cs) {
        if (cs.getGrayChannel() != null) {
            cs.getGrayChannel().accept((StyleVisitor)this);
        }
        if (cs.getRGBChannels() != null) {
            for (SelectedChannelType ch : cs.getRGBChannels()) {
                if (ch == null) continue;
                ch.accept((StyleVisitor)this);
            }
        }
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
        if (sct.getContrastEnhancement() != null) {
            sct.getContrastEnhancement().accept((StyleVisitor)this);
        }
    }

    public void visit(ShadedRelief sr) {
    }
}

