/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.capability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.capability.Operator;
import org.geotools.api.parameter.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.filter.capability.OperatorImpl;

public class FunctionNameImpl
extends OperatorImpl
implements FunctionName {
    Name functionName;
    List<Parameter<?>> args;
    Parameter<?> ret;

    public FunctionNameImpl(String name, int argumentCount) {
        this((Name)new NameImpl(name), argumentCount);
    }

    public FunctionNameImpl(Name name, int argumentCount) {
        this(name, FunctionNameImpl.generateReturn(), FunctionNameImpl.generateArguments(argumentCount));
    }

    public FunctionNameImpl(String name, String ... argumentsNames) {
        this((Name)new NameImpl(name), argumentsNames);
    }

    public FunctionNameImpl(Name name, String ... argumentsNames) {
        this(name, argumentsNames.length, Arrays.asList(argumentsNames));
    }

    public FunctionNameImpl(String name, List<String> argumentsNames) {
        this((Name)new NameImpl(name), argumentsNames);
    }

    public FunctionNameImpl(Name name, List<String> argumentsNames) {
        this(name, argumentsNames.size(), argumentsNames);
    }

    public FunctionNameImpl(String name, int argumentCount, List<String> argumentsNames) {
        this((Name)new NameImpl(name), argumentCount, argumentsNames);
    }

    public FunctionNameImpl(Name name, int argumentCount, List<String> argumentsNames) {
        this(name, FunctionNameImpl.generateReturn(), FunctionNameImpl.generateArguments(argumentsNames));
    }

    public FunctionNameImpl(String name, int argumentCount, String ... argumentsNames) {
        this((Name)new NameImpl(name), argumentCount, argumentsNames);
    }

    public FunctionNameImpl(Name name, int argumentCount, String ... argumentsNames) {
        this(name, argumentCount, Arrays.asList(argumentsNames));
    }

    public FunctionNameImpl(FunctionName copy) {
        super((Operator)copy);
        this.functionName = copy.getFunctionName();
        this.ret = copy.getReturn();
        this.args = copy.getArguments();
    }

    public FunctionNameImpl(String name, Class<?> returnType, Parameter<?> ... arguments) {
        this((Name)new NameImpl(name), returnType, arguments);
    }

    public FunctionNameImpl(Name name, Class<?> returnType, Parameter<?> ... arguments) {
        this(name, FunctionNameImpl.parameter(name.getLocalPart(), returnType), Arrays.asList(arguments));
    }

    public FunctionNameImpl(String name, Parameter<?> retern, Parameter<?> ... arguments) {
        this((Name)new NameImpl(name), retern, arguments);
    }

    public FunctionNameImpl(Name name, Parameter<?> retern, Parameter<?> ... arguments) {
        this(name, retern, Arrays.asList(arguments));
    }

    public FunctionNameImpl(String name, Parameter<?> retern, List<Parameter<?>> arguments) {
        this((Name)new NameImpl(name), retern, arguments);
    }

    public FunctionNameImpl(Name name, Parameter<?> retern, List<Parameter<?>> arguments) {
        super(name.getLocalPart());
        this.functionName = name;
        this.ret = retern;
        this.args = arguments;
    }

    public Name getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getName() {
        return this.getFunctionName().getLocalPart();
    }

    public int getArgumentCount() {
        int count = 0;
        int variable = 1;
        for (Parameter<?> argument : this.args) {
            if (argument.getMinOccurs() != argument.getMaxOccurs()) {
                variable = -1;
            }
            count += argument.getMinOccurs();
        }
        return variable * count;
    }

    public List<Parameter<?>> getArguments() {
        return this.args;
    }

    public Parameter<?> getReturn() {
        return this.ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.args != null) {
            result = 31 * result + this.args.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionNameImpl other = (FunctionNameImpl)obj;
        if (this.args == null) {
            return other.args == null;
        }
        return this.args.equals(other.args);
    }

    public List<String> getArgumentNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Parameter<?> arg : this.args) {
            names.add(arg.getName());
        }
        return names;
    }

    private static Parameter<?> generateReturn() {
        return FunctionNameImpl.parameter("return", Object.class);
    }

    private static List<Parameter<?>> generateArguments(int count) {
        ArrayList args = new ArrayList();
        if (count < 0) {
            args.add(FunctionNameImpl.parameter("arg", Object.class, Math.abs(count), Integer.MAX_VALUE));
        } else {
            for (int i = 0; i < count; ++i) {
                args.add(FunctionNameImpl.parameter("arg" + i, Object.class, 1, 1));
            }
        }
        return args;
    }

    private static List<Parameter<?>> generateArguments(List<String> names) {
        ArrayList args = new ArrayList();
        for (String name : names) {
            args.add(FunctionNameImpl.parameter(name, Object.class, 1, 1));
        }
        return args;
    }

    public static <T> Parameter<T> parameter(String name, Class<T> type) {
        return new org.geotools.api.data.Parameter<T>(name, type);
    }

    public static <T> Parameter<T> parameter(String name, Class<T> type, int min, int max) {
        return new org.geotools.api.data.Parameter<T>(name, type, min, max);
    }

    public static <T> Parameter<T> parameter(String name, Class<T> type, String title, String description) {
        return new org.geotools.api.data.Parameter<T>(name, type, title, description);
    }
}

