/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.FilterFunction_property;
import org.geotools.filter.visitor.DefaultFilterVisitor;

public class FilterAttributeExtractor
extends DefaultFilterVisitor {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    protected Set<String> attributeNames = new HashSet<String>();
    protected Set<PropertyName> propertyNames = new HashSet<PropertyName>();
    protected boolean usingVolatileFunctions;
    protected boolean usingDynamicProperties;
    protected SimpleFeatureType featureType;

    public FilterAttributeExtractor() {
        this(null);
    }

    public FilterAttributeExtractor(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public Set<String> getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    public Set<PropertyName> getPropertyNameSet() {
        return this.propertyNames;
    }

    public String[] getAttributeNames() {
        return this.attributeNames.toArray(new String[this.attributeNames.size()]);
    }

    public void clear() {
        this.attributeNames = new HashSet<String>();
        this.usingVolatileFunctions = false;
    }

    @Override
    public Object visit(PropertyName expression, Object data) {
        if (data instanceof Set && data != this.attributeNames) {
            Set cast;
            this.attributeNames = cast = (Set)data;
        }
        this.propertyNames.add(expression);
        if (this.featureType != null) {
            AttributeDescriptor type = (AttributeDescriptor)expression.evaluate((Object)this.featureType, AttributeDescriptor.class);
            if (type != null) {
                this.attributeNames.add(type.getLocalName());
            } else {
                this.attributeNames.add(expression.getPropertyName());
            }
        } else {
            this.attributeNames.add(expression.getPropertyName());
        }
        return this.attributeNames;
    }

    @Override
    public Object visit(Function expression, Object data) {
        if (expression instanceof VolatileFunction) {
            this.usingVolatileFunctions = true;
        }
        if (expression instanceof FilterFunction_property) {
            boolean foundLiteral = false;
            if (expression.getParameters() != null && expression.getParameters().size() > 0) {
                String name;
                Expression firstParam = (Expression)expression.getParameters().get(0);
                FilterAttributeExtractor secondary = new FilterAttributeExtractor();
                firstParam.accept((ExpressionVisitor)secondary, null);
                if (secondary.isConstantExpression() && (name = (String)firstParam.evaluate(null, String.class)) != null) {
                    this.attributeNames.add(name);
                    this.propertyNames.add(FF.property(name));
                    foundLiteral = true;
                }
            }
            if (!foundLiteral) {
                this.usingDynamicProperties = true;
            }
        }
        return super.visit(expression, data);
    }

    public boolean isConstantExpression() {
        return !this.usingVolatileFunctions && !this.usingDynamicProperties && this.getAttributeNameSet().isEmpty();
    }

    public boolean isUsingDynamincProperties() {
        return this.usingDynamicProperties;
    }
}

