/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.data.util.NumericConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class PercentageConverterFactory
implements ConverterFactory {
    static final PercentageConverter INSTANCE = new PercentageConverter();

    public Converter createConverter(Class source, Class target, Hints hints) {
        target = NumericConverterFactory.primitiveToWrapperClass(target);
        if (!String.class.isAssignableFrom(source)) {
            return null;
        }
        if (Double.class.equals((Object)target) || Float.class.equals((Object)target)) {
            return INSTANCE;
        }
        return null;
    }

    static class PercentageConverter
    implements Converter {
        PercentageConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            String s = (String)source;
            if (!s.endsWith("%")) {
                return null;
            }
            String number = s.substring(0, s.length() - 1);
            if (Double.class.equals(target)) {
                double value = Double.valueOf(number);
                return target.cast(value / 100.0);
            }
            if (Float.class.equals(target)) {
                float value = Float.valueOf(number).floatValue();
                return target.cast(Float.valueOf(value / 100.0f));
            }
            return null;
        }
    }
}

