/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.FindException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class EmbeddedModulePath {
    private static final String MODULE_INFO = "module-info.class";
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private static final int BASE_VERSION_FEATURE = 8;
    private static final int RUNTIME_VERSION_FEATURE = Runtime.version().feature();
    static final String MRJAR_PREFIX_PATH = "META-INF/versions";
    private static final Pattern DASH_VERSION = Pattern.compile("-(\\d+(\\.|$))");
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    static ModuleDescriptor descriptorFor(Path path) {
        try {
            Optional<ModuleDescriptor> vmd = EmbeddedModulePath.getModuleInfoVersioned(path);
            if (vmd.isPresent()) {
                return vmd.get();
            }
            if (EmbeddedModulePath.hasRootModuleInfo(path)) {
                return EmbeddedModulePath.readModuleInfo(path.resolve(MODULE_INFO), path);
            }
            return EmbeddedModulePath.descriptorForAutomatic(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ModuleDescriptor descriptorForAutomatic(Path path) throws IOException {
        ModuleDescriptor.Builder builder;
        String moduleName = EmbeddedModulePath.moduleNameFromManifestOrNull(path);
        if (moduleName == null) {
            throw new FindException("automatic module without a manifest name is not supported, for: " + path);
        }
        try {
            builder = ModuleDescriptor.newAutomaticModule(moduleName);
        }
        catch (IllegalArgumentException e2) {
            throw new FindException(AUTOMATIC_MODULE_NAME + ": " + e2.getMessage());
        }
        EmbeddedModulePath.version(path.getFileName().toString()).ifPresent(builder::version);
        ScanResult scan = EmbeddedModulePath.scan(path);
        String separator = path.getFileSystem().getSeparator();
        builder.packages(scan.classFiles().stream().map(cf -> EmbeddedModulePath.toPackageName(cf, separator)).flatMap(Optional::stream).collect(Collectors.toSet()));
        EmbeddedModulePath.services(scan.serviceFiles(), path).entrySet().forEach(e -> builder.provides((String)e.getKey(), (List)e.getValue()));
        return builder.build();
    }

    private EmbeddedModulePath() {
    }

    static boolean hasRootModuleInfo(Path path) {
        return Files.exists(path.resolve(MODULE_INFO), new LinkOption[0]);
    }

    static Path maybeRemoveMRJARPrefix(Path path) {
        if (path.startsWith(MRJAR_PREFIX_PATH)) {
            assert (path.getNameCount() >= 3);
            return path.subpath(3, path.getNameCount());
        }
        return path;
    }

    static Set<String> explodedPackages(Path dir) {
        Set<String> set;
        block8: {
            String separator = dir.getFileSystem().getSeparator();
            Stream<Path> stream = Files.find(dir, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]);
            try {
                set = stream.map(path -> dir.relativize((Path)path)).map(EmbeddedModulePath::maybeRemoveMRJARPrefix).map(path -> EmbeddedModulePath.toPackageName(path, separator)).flatMap(Optional::stream).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException x) {
                    throw new UncheckedIOException(x);
                }
            }
            stream.close();
        }
        return set;
    }

    private static ModuleDescriptor readModuleInfo(Path miPath, Path pkgsRoot) throws IOException {
        try (InputStream is = Files.newInputStream(miPath, new OpenOption[0]);){
            ModuleDescriptor moduleDescriptor = ModuleDescriptor.read(is, () -> EmbeddedModulePath.explodedPackages(pkgsRoot));
            return moduleDescriptor;
        }
    }

    private static Optional<ModuleDescriptor> getModuleInfoVersioned(Path rootPath) throws IOException {
        for (int v = RUNTIME_VERSION_FEATURE; v >= 8; --v) {
            Path mi = rootPath.resolve("META-INF").resolve("versions").resolve(Integer.toString(v)).resolve(MODULE_INFO);
            if (!Files.exists(mi, new LinkOption[0])) continue;
            return Optional.of(EmbeddedModulePath.readModuleInfo(mi, rootPath));
        }
        return Optional.empty();
    }

    static ScanResult scan(Path path) throws IOException {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            Map map = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> path.relativize((Path)p).toString()).filter(p -> p.endsWith(".class") ^ p.startsWith(SERVICES_PREFIX)).collect(Collectors.partitioningBy(e -> e.startsWith(SERVICES_PREFIX), Collectors.toSet()));
            ScanResult scanResult = new ScanResult(map.get(Boolean.FALSE), map.get(Boolean.TRUE));
            return scanResult;
        }
    }

    static Optional<ModuleDescriptor.Version> version(String jarName) {
        if (!jarName.endsWith(".jar")) {
            throw new IllegalArgumentException("unexpected jar name: " + jarName);
        }
        String name = jarName.substring(0, jarName.length() - 4);
        Matcher matcher = DASH_VERSION.matcher(name);
        if (matcher.find()) {
            int start = matcher.start();
            try {
                String tail = name.substring(start + 1);
                return Optional.of(ModuleDescriptor.Version.parse(tail));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    static Map<String, List<String>> services(Set<String> serviceFiles, Path path) throws IOException {
        Set serviceNames = serviceFiles.stream().map(EmbeddedModulePath::toServiceName).flatMap(Optional::stream).collect(Collectors.toSet());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String sn : serviceNames) {
            Path se = path.resolve(SERVICES_PREFIX + sn);
            List<String> providerClasses = Files.readAllLines(se).stream().map(EmbeddedModulePath::dropCommentAndTrim).filter(Predicate.not(String::isEmpty)).toList();
            if (providerClasses.isEmpty()) continue;
            map.put(sn, providerClasses);
        }
        return map;
    }

    private static String dropCommentAndTrim(String line) {
        int ci = line.indexOf(35);
        if (ci >= 0) {
            line = line.substring(0, ci);
        }
        return line.trim();
    }

    static Optional<String> toPackageName(Path file, String separator) {
        Path parent = file.getParent();
        if (parent == null) {
            String name = file.toString();
            if (name.endsWith(".class") && !name.equals(MODULE_INFO)) {
                String msg = name + " found in top-level directory (unnamed package not allowed in module)";
                throw new InvalidModuleDescriptorException(msg);
            }
            return Optional.empty();
        }
        String pn = parent.toString().replace(separator, ".");
        if (EmbeddedModulePath.isPackageName(pn)) {
            return Optional.of(pn);
        }
        return Optional.empty();
    }

    static Optional<String> toPackageName(String name, String separator) {
        assert (!name.endsWith(separator));
        int index = name.lastIndexOf(separator);
        if (index == -1) {
            if (name.endsWith(".class") && !name.equals(MODULE_INFO)) {
                String msg = name + " found in top-level directory (unnamed package not allowed in module)";
                throw new InvalidModuleDescriptorException(msg);
            }
            return Optional.empty();
        }
        String pn = name.substring(0, index).replace(separator, ".");
        if (EmbeddedModulePath.isPackageName(pn)) {
            return Optional.of(pn);
        }
        return Optional.empty();
    }

    static Optional<String> toServiceName(String cf) {
        String sn;
        String prefix;
        if (!cf.startsWith(SERVICES_PREFIX)) {
            throw new IllegalArgumentException("unexpected service " + cf);
        }
        if (SERVICES_PREFIX.length() < cf.length() && (prefix = cf.substring(0, SERVICES_PREFIX.length())).equals(SERVICES_PREFIX) && EmbeddedModulePath.isClassName(sn = cf.substring(SERVICES_PREFIX.length()))) {
            return Optional.of(sn);
        }
        return Optional.empty();
    }

    static boolean isPackageName(String name) {
        return EmbeddedModulePath.isTypeName(name);
    }

    static boolean isClassName(String name) {
        return EmbeddedModulePath.isTypeName(name);
    }

    static boolean isTypeName(String name) {
        int next;
        int off = 0;
        while ((next = name.indexOf(46, off)) != -1) {
            String id = name.substring(off, next);
            if (!EmbeddedModulePath.isJavaIdentifier(id)) {
                return false;
            }
            off = next + 1;
        }
        String last = name.substring(off);
        return EmbeddedModulePath.isJavaIdentifier(last);
    }

    static boolean isJavaIdentifier(String str) {
        int cp;
        if (str.isEmpty()) {
            return false;
        }
        int first = Character.codePointAt(str, 0);
        if (!Character.isJavaIdentifierStart(first)) {
            return false;
        }
        for (int i = Character.charCount(first); i < str.length(); i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    static String moduleNameFromManifestOrNull(Path path) throws IOException {
        Path mp = path.resolve(MANIFEST_PATH);
        if (Files.exists(mp, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(mp, new OpenOption[0]);){
                Manifest manifest = new Manifest(is);
                String string = manifest.getMainAttributes().getValue(AUTOMATIC_MODULE_NAME);
                return string;
            }
        }
        return null;
    }

    record ScanResult(Set<String> classFiles, Set<String> serviceFiles) {
    }
}

