/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.index.es;

import org.fao.geonet.index.IServerStatusChecker;
import org.fao.geonet.index.State;
import org.fao.geonet.index.Status;
import org.fao.geonet.index.es.EsRestClient;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class EsServerStatusChecker
extends QuartzJobBean
implements IServerStatusChecker {
    @Autowired
    private Status status;
    private boolean indexChecked = false;
    @Autowired
    EsRestClient client;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.checkState();
    }

    @Override
    public Status checkState() {
        String status = null;
        try {
            status = this.client.getServerStatus();
            if ("green".equalsIgnoreCase(status)) {
                this.status.setState(State.GREEN, "Index up and running. All green.");
                this.checkIndexState();
            } else if ("yellow".equalsIgnoreCase(status)) {
                this.status.setState(State.YELLOW, "Index status is yellow. Check index server log.");
                this.checkIndexState();
            } else {
                this.status.setState(State.RED, "Index is down");
            }
        }
        catch (Exception e) {
            this.status.setState(State.UNINITIALIZED, String.format("Unable to revive connection to %s. Error is %s", this.client.getServerUrl(), e.getMessage()));
        }
        return this.status;
    }

    @Override
    public Status checkIndexState() {
        if (!this.indexChecked) {
            this.indexChecked = true;
        }
        return null;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }
}

