/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.index.es;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ElasticsearchVersionInfo;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryStringQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.WrapperQuery;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryResponse;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.indices.AnalyzeRequest;
import co.elastic.clients.elasticsearch.indices.AnalyzeResponse;
import co.elastic.clients.elasticsearch.indices.IndicesStatsRequest;
import co.elastic.clients.elasticsearch.indices.IndicesStatsResponse;
import co.elastic.clients.elasticsearch.indices.analyze.AnalyzeToken;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class EsRestClient
implements InitializingBean {
    private static EsRestClient instance;
    private ElasticsearchClient client;
    private ElasticsearchAsyncClient asyncClient;
    private String serverUrl;
    @Value(value="${es.protocol}")
    private String serverProtocol;
    @Value(value="${es.host}")
    private String serverHost;
    @Value(value="${es.port}")
    private String serverPort;
    @Value(value="${es.username}")
    private String username;
    @Value(value="${es.password}")
    private String password;
    private boolean activated = false;
    @Value(value="${kb.url}")
    private String dashboardAppUrl;
    public static final String ROUTING_KEY = "101";

    public static EsRestClient get() {
        return instance;
    }

    public ElasticsearchClient getClient() {
        return this.client;
    }

    public ElasticsearchAsyncClient getAsynchClient() {
        return this.asyncClient;
    }

    public String getDashboardAppUrl() {
        return this.dashboardAppUrl;
    }

    public void setDashboardAppUrl(String dashboardAppUrl) {
        this.dashboardAppUrl = dashboardAppUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((String)this.serverProtocol) || StringUtils.isBlank((String)this.serverHost) || StringUtils.isBlank((String)this.serverPort)) {
            Log.error((String)"geonetwork.index", (Object)String.format("Elasticsearch URL defined by serverProtocol='%s', serverHost='%s', serverPort='%s' is missing. Check configuration.", this.serverProtocol, this.serverHost, this.serverPort));
        }
        this.serverUrl = this.serverProtocol + "://" + this.serverHost + ":" + this.serverPort;
        if (StringUtils.isNotEmpty((String)this.serverUrl)) {
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.serverHost, Integer.parseInt(this.serverPort), this.serverProtocol)});
            if (this.serverProtocol.startsWith("https")) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        return true;
                    }
                }).build();
                NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                SSLIOSessionStrategy httpsIOSessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)hostnameVerifier);
                if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                    builder.setHttpClientConfigCallback(arg_0 -> EsRestClient.lambda$afterPropertiesSet$0(sslContext, (CredentialsProvider)credentialsProvider, arg_0));
                } else {
                    builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.useSystemProperties().setSSLContext(sslContext));
                }
            } else if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                builder.setHttpClientConfigCallback(arg_0 -> EsRestClient.lambda$afterPropertiesSet$2((CredentialsProvider)credentialsProvider, arg_0));
            } else {
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.useSystemProperties());
            }
            RestClient restClient = builder.build();
            RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            this.client = new ElasticsearchClient((ElasticsearchTransport)transport);
            this.asyncClient = new ElasticsearchAsyncClient((ElasticsearchTransport)transport);
            Class<EsRestClient> clazz = EsRestClient.class;
            synchronized (EsRestClient.class) {
                instance = this;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                this.activated = true;
            }
        } else {
            Log.debug((String)"geonetwork.index", (Object)String.format("No Elasticsearch URL defined '%s'. Check configuration.", this.serverUrl));
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public EsRestClient setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public EsRestClient setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public EsRestClient setPassword(String password) {
        this.password = password;
        return this;
    }

    public BulkResponse bulkRequest(String index, Map<String, String> docs) throws IOException {
        if (!this.activated) {
            throw new IOException("Index not yet activated.");
        }
        BulkRequest.Builder requestBuilder = new BulkRequest.Builder().index(index).refresh(Refresh.True);
        JsonpMapper jsonpMapper = ((ElasticsearchTransport)this.client._transport()).jsonpMapper();
        JsonProvider jsonProvider = jsonpMapper.jsonProvider();
        for (Map.Entry<String, String> entry : docs.entrySet()) {
            JsonData jd = JsonData.from((JsonParser)jsonProvider.createParser((Reader)new StringReader(entry.getValue())), (JsonpMapper)jsonpMapper);
            requestBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id((String)entry.getKey())).document((Object)jd)));
        }
        BulkRequest request = requestBuilder.build();
        try {
            return this.client.bulk(request);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size) throws Exception {
        return this.query(index, luceneQuery, filterQuery, includedFields, scriptedFields, from, size, null);
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, int from, int size) throws Exception {
        return this.query(index, luceneQuery, filterQuery, includedFields, new HashMap<String, String>(), from, size, null);
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size, List<SortOptions> sort) throws Exception {
        Query.Builder queryBuilder = new Query.Builder();
        queryBuilder.queryString(new QueryStringQuery.Builder().query(luceneQuery).build());
        Query.Builder filterBuilder = null;
        if (StringUtils.isNotEmpty((String)filterQuery)) {
            filterBuilder = new Query.Builder();
            filterBuilder.queryString(new QueryStringQuery.Builder().query(filterQuery).build());
        }
        return this.query(index, queryBuilder, filterBuilder, includedFields, scriptedFields, from, size, sort);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, Query.Builder postFilterBuilder, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size) throws Exception {
        return this.query(index, jsonQuery, postFilterBuilder, includedFields, scriptedFields, from, size, null);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, Query.Builder postFilterBuilder, Set<String> includedFields, int from, int size) throws Exception {
        return this.query(index, jsonQuery, postFilterBuilder, includedFields, new HashMap<String, String>(), from, size, null);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, Query.Builder postFilterBuilder, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size, List<SortOptions> sort) throws Exception {
        Query.Builder query = new Query.Builder();
        WrapperQuery.Builder wrapperQueryBuilder = new WrapperQuery.Builder();
        wrapperQueryBuilder.query(Base64.getEncoder().encodeToString(String.valueOf(jsonQuery).getBytes()));
        query.wrapper(wrapperQueryBuilder.build());
        return this.query(index, query, postFilterBuilder, includedFields, scriptedFields, from, size, sort);
    }

    public SearchResponse query(String index, Query.Builder queryBuilder, Query.Builder postFilterBuilder, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size, List<SortOptions> sort) throws Exception {
        if (!this.activated) {
            return null;
        }
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(index, new String[0]).from(Integer.valueOf(from)).size(Integer.valueOf(size)).query(queryBuilder.build()).trackTotalHits(th -> th.enabled(Boolean.valueOf(true))).source(sc -> sc.filter(f -> f.includes(new ArrayList(includedFields))));
        if (postFilterBuilder != null) {
            searchRequestBuilder.postFilter(postFilterBuilder.build());
        }
        if (MapUtils.isNotEmpty(scriptedFields)) {
            for (Map.Entry<String, String> scriptedField : scriptedFields.entrySet()) {
                ScriptField scriptField = ScriptField.of(b -> b.script(sb -> sb.inline(is -> is.source((String)scriptedField.getValue()))));
                searchRequestBuilder.scriptFields(scriptedField.getKey(), scriptField);
            }
        }
        if (sort != null) {
            searchRequestBuilder.sort(sort);
        }
        SearchRequest searchRequest = searchRequestBuilder.build();
        try {
            return this.client.search(searchRequest, ObjectNode.class);
        }
        catch (ElasticsearchException esException) {
            Log.error((String)"geonetwork.index", (Object)String.format("Error during querying index. %s", esException.error().toString()));
            throw esException;
        }
    }

    public String deleteByQuery(String index, String query) throws Exception {
        if (!this.activated) {
            return "";
        }
        DeleteByQueryRequest request = DeleteByQueryRequest.of(b -> b.index(new ArrayList<String>(Arrays.asList(index))).q(query).refresh(Boolean.valueOf(true)));
        DeleteByQueryResponse deleteByQueryResponse = this.client.deleteByQuery(request);
        if (deleteByQueryResponse.deleted() >= 0L) {
            return String.format("Record removed. %s.", deleteByQueryResponse.deleted());
        }
        StringBuilder stringBuilder = new StringBuilder();
        deleteByQueryResponse.failures().forEach(f -> stringBuilder.append(f.toString()));
        throw new IOException(String.format("Error during removal. Errors are '%s'.", stringBuilder));
    }

    public Map<String, Object> getDocument(String index, String id) throws Exception {
        if (!this.activated) {
            return Collections.emptyMap();
        }
        GetRequest request = GetRequest.of(b -> b.index(index).id(id));
        GetResponse response = this.client.get(request, ObjectNode.class);
        if (response.found()) {
            ObjectMapper objectMapper = new ObjectMapper();
            return (Map)objectMapper.convertValue(response.source(), Map.class);
        }
        throw new Exception(String.format("Document with id %s not found", id));
    }

    public Map<String, String> getFieldsValues(String index, String id, Set<String> fields, String language) throws Exception {
        if (!this.activated) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map<String, Object> sources = this.getDocument(index, id);
        for (String field : fields) {
            Object value = sources.get(field);
            if (value instanceof String) {
                fieldValues.put(field, (String)value);
                continue;
            }
            if (!(value instanceof Map) || !field.endsWith("Object")) continue;
            Map valueMap = (Map)value;
            String languageValue = (String)valueMap.get("lang" + language);
            fieldValues.put(field, languageValue != null ? languageValue : (String)valueMap.get("default"));
        }
        return fieldValues;
    }

    public static String analyzeField(String collection, String analyzer, String fieldValue) {
        AnalyzeRequest analyzeRequest = AnalyzeRequest.of(b -> b.index(collection).analyzer(analyzer).text(fieldValue.replace(",", ""), new String[0]));
        try {
            AnalyzeResponse response = EsRestClient.get().client.indices().analyze(analyzeRequest);
            List tokens = response.tokens();
            if (tokens.size() == 1) {
                String type = ((AnalyzeToken)tokens.get(0)).type();
                if ("SYNONYM".equals(type) || "word".equals(type)) {
                    return ((AnalyzeToken)tokens.get(0)).token();
                }
                return "";
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getServerStatus() throws IOException {
        HealthResponse response = this.client.cluster().health();
        return response.status().toString();
    }

    public String getServerVersion() throws IOException, ElasticsearchException {
        ElasticsearchVersionInfo version = this.client.info().version();
        return version.number();
    }

    public IndicesStatsResponse getIndexStats(String index) throws IOException {
        IndicesStatsRequest statsRequest = IndicesStatsRequest.of(b -> b.index(index, new String[0]));
        return this.client.indices().stats(statsRequest);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$afterPropertiesSet$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.useSystemProperties().setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$afterPropertiesSet$0(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.useSystemProperties().setSSLContext(sslContext).setDefaultCredentialsProvider(credentialsProvider);
    }
}

