/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.vec.internal;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.quantization.ScalarQuantizedVectorSimilarity;
import org.elasticsearch.vec.internal.AbstractScalarQuantizedVectorScorer;

public final class Euclidean
extends AbstractScalarQuantizedVectorScorer {
    public Euclidean(int dims, int maxOrd, float scoreCorrectionConstant, IndexInput input) {
        super(dims, maxOrd, scoreCorrectionConstant, input, ScalarQuantizedVectorSimilarity.fromVectorSimilarity((VectorSimilarityFunction)VectorSimilarityFunction.EUCLIDEAN, (float)scoreCorrectionConstant));
    }

    @Override
    public float score(int firstOrd, int secondOrd) throws IOException {
        this.checkOrdinal(firstOrd);
        this.checkOrdinal(secondOrd);
        int length = this.dims;
        long firstByteOffset = (long)firstOrd * (long)(length + 4);
        long secondByteOffset = (long)secondOrd * (long)(length + 4);
        MemorySegment firstSeg = this.segmentSlice(firstByteOffset, length);
        MemorySegment secondSeg = this.segmentSlice(secondByteOffset, length);
        if (firstSeg != null && secondSeg != null) {
            int squareDistance = Euclidean.squareDistance(firstSeg, secondSeg, length);
            float adjustedDistance = (float)squareDistance * this.scoreCorrectionConstant;
            return 1.0f / (1.0f + adjustedDistance);
        }
        return this.fallbackScore(firstByteOffset, secondByteOffset);
    }

    @Override
    public Euclidean copy() {
        return new Euclidean(this.dims, this.maxOrd, this.scoreCorrectionConstant, this.input.clone());
    }
}

