/*
 * Decompiled with CFR 0.152.
 */
package org.geonetwork.map.wms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.utils.Xml;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SLDUtil {
    public static final String LOGGER = "geonetwork.util.sld";

    public static Map<String, String> parseSLD(URI url, String layers) throws URISyntaxException, IOException, ParseException {
        HashMap<String, String> hash = new HashMap<String, String>();
        String requestUrl = SLDUtil.getGetStyleRequest(url, layers);
        HttpGet httpGet = new HttpGet(requestUrl);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
        ContentType contentType = new ContentType(httpResponse.getEntity().getContentType().getValue());
        String charset = contentType.getParameter("charset");
        hash.put("charset", charset);
        hash.put("content", IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)charset).trim());
        return hash;
    }

    public static String getGetStyleRequest(URI uri, String layers) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(uri);
        builder.addParameter("service", "WMS");
        builder.addParameter("request", "GetStyles");
        builder.addParameter("version", "1.1.1");
        builder.addParameter("layers", layers);
        return builder.build().toString();
    }

    public static void insertFilter(Element doc, Filter filter) throws JDOMException, IOException {
        String sFilter = SLDUtil.encodeFilter(filter);
        Element newFilterElt = Xml.loadString((String)sFilter, (boolean)false);
        List newFilterChildren = ((Element)newFilterElt.clone()).getChildren();
        if (newFilterChildren.size() > 0) {
            Content newFilterContent = ((Element)newFilterChildren.get(0)).detach();
            List rules = Xml.selectNodes((Element)doc, (String)"*//sld:Rule", Arrays.asList(Geonet.Namespaces.SLD));
            if (rules.size() == 0) {
                rules = Xml.selectNodes((Element)doc, (String)"*//se:Rule", Arrays.asList(Geonet.Namespaces.SE));
            }
            for (Element rule : rules) {
                List filters = Xml.selectNodes((Element)rule, (String)"ogc:Filter", Arrays.asList(Geonet.Namespaces.OGC));
                if (filters.size() == 0) {
                    rule.addContent((Content)((Element)newFilterElt.clone()));
                    continue;
                }
                if (filters.size() == 1) {
                    Element sldFilterElt = (Element)filters.get(0);
                    Element filterContent = (Element)sldFilterElt.getChildren().get(0);
                    filterContent.detach();
                    sldFilterElt.removeContent();
                    Element andElt = new Element("And", Geonet.Namespaces.OGC);
                    andElt.addContent((Content)filterContent);
                    andElt.addContent((Content)newFilterContent.clone());
                    sldFilterElt.addContent((Content)andElt);
                    continue;
                }
                throw new JDOMException("A rule must have maximum one ogc:filter element");
            }
        }
    }

    public static String encodeFilter(Filter filter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OGCConfiguration configuration = new OGCConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        encoder.encode((Object)filter, OGC.Filter, (OutputStream)outputStream);
        return ((Object)outputStream).toString();
    }

    public static Filter generateCustomFilter(JSONObject userFilters) throws JSONException {
        FilterFactory ff2 = CommonFactoryFinder.getFilterFactory();
        JSONArray filters = userFilters.getJSONArray("filters");
        LinkedList<Filter> res = new LinkedList<Filter>();
        for (int i = 0; i < filters.length(); ++i) {
            res.add(SLDUtil.generateFilter(filters.getJSONObject(i)));
        }
        if (res.size() > 1) {
            return ff2.and(res);
        }
        return (Filter)res.get(0);
    }

    private static Filter generateFilter(JSONObject jsonObject) throws JSONException {
        FilterFactory ff2 = CommonFactoryFinder.getFilterFactory();
        String fieldName = jsonObject.getString("field_name");
        LinkedList<Filter> res = new LinkedList<Filter>();
        JSONArray filters = jsonObject.getJSONArray("filter");
        for (int i = 0; i < filters.length(); ++i) {
            res.add(SLDUtil.generateFilter2(fieldName, filters.getJSONObject(i)));
        }
        if (res.size() > 1) {
            return ff2.or(res);
        }
        return (Filter)res.get(0);
    }

    private static Filter generateFilter2(String fieldName, JSONObject jsonObject) throws JSONException {
        FilterFactory ff2 = CommonFactoryFinder.getFilterFactory();
        String filterType = jsonObject.getString("filter_type");
        LinkedList<Object> parameters = new LinkedList<Object>();
        JSONArray params = jsonObject.getJSONArray("params");
        for (int i = 0; i < params.length(); ++i) {
            parameters.add(params.get(i));
        }
        if (filterType.equals("PropertyIsEqualTo")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.equals((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)));
        }
        if (filterType.equals("PropertyIsNotEqualTo")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.notEqual((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)));
        }
        if (filterType.equals("PropertyIsLessThan")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.less((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)));
        }
        if (filterType.equals("PropertyIsLessThanOrEqualTo")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.lessOrEqual((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)));
        }
        if (filterType.equals("PropertyIsGreaterThan")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.greater((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)));
        }
        if (filterType.equals("PropertyIsGreaterThanOrEqualTo")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.greaterOrEqual((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)));
        }
        if (filterType.equals("PropertyIsLike")) {
            if (parameters.size() != 1) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.like((Expression)ff2.property(fieldName), (String)parameters.get(0));
        }
        if (filterType.equals("PropertyIsNull")) {
            if (parameters.size() != 0) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.isNull((Expression)ff2.property(fieldName));
        }
        if (filterType.equals("PropertyIsBetween")) {
            if (parameters.size() != 2) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.between((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0)), (Expression)ff2.literal(parameters.get(1)));
        }
        if (filterType.equals("PropertyIsBetweenExclusive")) {
            if (parameters.size() != 2) {
                throw new JSONException("Invalid parameter count");
            }
            return ff2.and((Filter)ff2.greater((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(0))), (Filter)ff2.less((Expression)ff2.property(fieldName), (Expression)ff2.literal(parameters.get(1))));
        }
        throw new JSONException("No implementation for filter type : " + filterType);
    }
}

