/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;

public class LogUtil {
    private LogUtil() {
    }

    public static String initializeHarvesterLog(String type, String name) {
        String harvesterName = name.replaceAll("\\W+", "_");
        String harvesterType = type.replaceAll("\\W+", "_");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String logfile = "harvester_" + harvesterType + "_" + harvesterName + "_" + dateFormat.format(new Date(System.currentTimeMillis())) + ".log";
        String timeZoneSetting = ((SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class)).getValue("system/server/timeZone");
        if (StringUtils.isBlank((String)timeZoneSetting)) {
            timeZoneSetting = TimeZone.getDefault().getID();
        }
        ThreadContext.put((String)"harvest", (String)harvesterName);
        ThreadContext.put((String)"logfile", (String)logfile);
        ThreadContext.put((String)"timeZone", (String)timeZoneSetting);
        return logfile;
    }
}

