/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.fao.geonet.Util;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class ElementLib {
    public Set<String> getIds(Element elem) {
        HashSet<String> hs = new HashSet<String>();
        for (Object child : elem.getChildren()) {
            hs.add(((Element)child).getChildText("id"));
        }
        return hs;
    }

    public Element pruneChildren(Element elem, Set<Integer> ids) {
        ArrayList<Element> alToPrune = new ArrayList<Element>();
        for (Object obj : elem.getChildren()) {
            Element child = (Element)obj;
            String id = child.getChildText("id");
            if (ids.contains(Integer.valueOf(id))) continue;
            alToPrune.add(child);
        }
        for (Element child : alToPrune) {
            child.detach();
        }
        return elem;
    }

    public void add(Element el, String name, Object value) {
        if (value != null) {
            el.addContent((Content)new Element(name).setText(value.toString()));
        }
    }

    public String eval(Element elem, String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            if ((elem = elem.getChild(st.nextToken())) != null) continue;
            return null;
        }
        return elem.getText().trim();
    }

    public void substitute(Element el, Map<String, ? extends Object> vars) {
        List attributes = el.getAttributes();
        for (Attribute a : attributes) {
            String text = a.getValue();
            text = this.substitute(text, vars);
            a.setValue(text);
        }
        for (int i = 0; i < el.getContentSize(); ++i) {
            Content c = el.getContent(i);
            if (c instanceof Element) {
                this.substitute((Element)c, vars);
                continue;
            }
            if (!(c instanceof Text)) continue;
            Text t = (Text)c;
            String text = t.getText();
            text = this.substitute(text, vars);
            t.setText(text);
        }
    }

    private String substitute(String text, Map<String, ? extends Object> vars) {
        for (Map.Entry<String, ? extends Object> entry : vars.entrySet()) {
            String name = entry.getKey();
            String value = "";
            if (entry.getValue() != null) {
                value = entry.getValue().toString();
            }
            text = Util.replaceString((String)text, (String)name, (String)value);
        }
        return text;
    }
}

