/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.setting;

import com.google.common.xml.XmlEscapers;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.ServletContext;
import jeeves.server.context.ServiceContext;
import jeeves.server.sources.http.ServletPathFinder;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.domain.HarvesterSetting;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.Setting_;
import org.fao.geonet.kernel.setting.Settings;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.web.DefaultLanguage;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class SettingManager {
    public static final ZoneId DEFAULT_SERVER_TIMEZONE = ZoneId.systemDefault();
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ServletContext servletContext;
    private ServletPathFinder pathFinder;
    @Autowired
    SettingRepository repo;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    StandardPBEStringEncryptor encryptor;
    @Autowired
    DefaultLanguage defaultLanguage;
    @Autowired
    FeedbackLanguages feedbackLanguages;

    @PostConstruct
    private void init() {
        this.pathFinder = new ServletPathFinder(this.servletContext);
        String zoneId = StringUtils.defaultIfBlank((String)this.getValue("system/server/timeZone"), (String)DEFAULT_SERVER_TIMEZONE.getId());
        TimeZone tzFromSettings = TimeZone.getTimeZone(zoneId);
        TimeZone.setDefault(tzFromSettings);
    }

    public List<Setting> getAll() {
        return this.repo.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Setting_.name}));
    }

    public Element getAllAsXML(boolean asTree) {
        Element env = new Element("settings");
        List settings = this.repo.findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Setting_.name}));
        HashMap<String, Element> pathElements = new HashMap<String, Element>();
        for (Setting setting : settings) {
            if (asTree) {
                this.buildXmlTree(env, pathElements, setting);
                continue;
            }
            Element settingEl = new Element("setting");
            settingEl.setAttribute("name", setting.getName());
            settingEl.setAttribute("position", String.valueOf(setting.getPosition()));
            settingEl.setAttribute("datatype", String.valueOf(setting.getDataType()));
            settingEl.setAttribute("internal", String.valueOf(setting.isInternal()));
            settingEl.setText(setting.getValue());
            env.addContent((Content)settingEl);
        }
        return env;
    }

    private void buildXmlTree(Element env, Map<String, Element> pathElements, Setting setting) {
        String[] segments = setting.getName().split("/");
        Element parent = env;
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            path.append("/").append(segment);
            Element currentElement = pathElements.get(path.toString());
            if (currentElement == null) {
                try {
                    currentElement = new Element(segment);
                    currentElement.setAttribute("name", path.substring(1));
                    currentElement.setAttribute("position", String.valueOf(setting.getPosition()));
                    if (i == segments.length - 1) {
                        SettingDataType dataType = setting.getDataType() != null ? setting.getDataType() : SettingDataType.STRING;
                        currentElement.setAttribute("datatype", String.valueOf(dataType.ordinal()));
                        currentElement.setAttribute("datatypeName", dataType.name());
                        if (setting.getValue() != null) {
                            currentElement.setText(XmlEscapers.xmlContentEscaper().escape(setting.getValue()));
                        }
                    } else {
                        currentElement.setText("");
                    }
                    parent.addContent((Content)currentElement);
                    pathElements.put(path.toString(), currentElement);
                }
                catch (Exception e) {
                    Log.error((String)("Settings table has an illegal setting: " + path), (Object)e);
                }
            }
            parent = currentElement;
        }
    }

    public String getValue(String path) {
        return this.getValue(path, false);
    }

    public String getValue(Settings.GNSetting setting) {
        return this.getValue(setting.getName(), setting.isNullable());
    }

    public String getValue(String path, boolean nullable) {
        Optional se;
        if (Log.isDebugEnabled((String)"geonetwork.settings")) {
            Log.trace((String)"geonetwork.settings", (Object)("Requested setting with name: " + path));
        }
        if (!(se = this.repo.findById((Object)path)).isPresent()) {
            Log.error((String)"geonetwork.settings", (Object)("  Requested setting with name: " + path + "  not found. Add it to the settings table."));
            return null;
        }
        String value = ((Setting)se.get()).getValue();
        if (!this.encryptor.isInitialized()) {
            if (!((Setting)se.get()).isEncrypted()) {
                value = ((Setting)se.get()).getStoredValue();
            } else {
                throw new IllegalStateException("Encrypted settings can't be accessed before encryptor is initialized");
            }
        }
        if (value == null && !nullable) {
            Log.warning((String)"geonetwork.settings", (Object)("  Requested setting with name: " + path + " but null value found. Check the settings table."));
        }
        return value;
    }

    public List<Setting> getSettings(String[] keys) {
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Optional se = this.repo.findById((Object)key);
            if (!se.isPresent()) {
                Log.warning((String)"geonetwork.settings", (Object)("  Requested setting with name: " + key + " not found. Add it to the settings table."));
                continue;
            }
            settings.add((Setting)se.get());
        }
        return settings;
    }

    public Element getValues(String[] keys) {
        Element env = new Element("settings");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Optional se = this.repo.findById((Object)key);
            if (!se.isPresent()) {
                Log.error((String)"geonetwork.settings", (Object)("  Requested setting with name: " + key + " not found. Add it to the settings table."));
                continue;
            }
            String value = ((Setting)se.get()).getValue();
            if (value == null) continue;
            Element setting = new Element("setting");
            setting.setAttribute("name", key).setAttribute("value", value);
            env.addContent((Content)setting);
        }
        return env;
    }

    public boolean getValueAsBool(String key) {
        String value = this.getValue(key);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean getValueAsBool(String key, boolean defaultValue) {
        String value = this.getValue(key);
        if (value != null) {
            return "y".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public Integer getValueAsInt(String key) {
        String value = this.getValue(key);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public Integer getValueAsInt(String key, Integer defaultValue) {
        String value = this.getValue(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public boolean setValue(String key, String value) {
        Optional settingOpt;
        if (Log.isDebugEnabled((String)"geonetwork.settings")) {
            Log.debug((String)"geonetwork.settings", (Object)("Setting with name: " + key + ", value: " + value));
        }
        if (!(settingOpt = this.repo.findById((Object)key)).isPresent()) {
            throw new NoSuchElementException("There is no existing setting element with the key: " + key);
        }
        Setting setting = (Setting)settingOpt.get();
        setting.getDataType().validate(value);
        setting.setValue(value);
        this.repo.save((Object)setting);
        if (key.equals("system/feedback/languages")) {
            this.feedbackLanguages.updateSupportedLocales();
        } else if (key.equals("system/feedback/translationFollowsText")) {
            this.feedbackLanguages.updateTranslationFollowsText();
        }
        return true;
    }

    public boolean setValue(Settings.GNSetting setting, String value) {
        return this.setValue(setting.getName(), value);
    }

    public boolean setValue(Settings.GNSetting setting, boolean value) {
        return this.setValue(setting.getName(), value);
    }

    public boolean setValue(String key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    public final boolean setValues(Map<String, String> values) {
        boolean success = true;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotEmpty((String)key)) continue;
            this.setValue(key, value);
        }
        return success;
    }

    public final boolean refresh() throws SQLException {
        this.entityManager.getEntityManagerFactory().getCache().evict(HarvesterSetting.class);
        return true;
    }

    public final String getSiteId() {
        return this.getValue("system/site/siteId");
    }

    public final String getSiteName() {
        return this.getValue("system/site/name");
    }

    public void setSiteUuid(String siteUuid) {
        this.setValue("system/site/siteId", siteUuid);
    }

    @Nonnull
    public String getSiteURL(@Nonnull ServiceContext context) {
        return this.getSiteURL(context.getLanguage());
    }

    @Nonnull
    public String getSiteURL(String language) {
        if (language == null) {
            language = this.defaultLanguage.getLanguage();
        }
        return this.getNodeURL() + language + "/";
    }

    @Nonnull
    public String getNodeURL() {
        return this.getBaseURL() + this.getNodeId() + "/";
    }

    @Nonnull
    public String getNodeId() {
        String nodeId = "srv";
        try {
            NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
            if (node != null) {
                nodeId = node.getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeId;
    }

    @Nonnull
    public String getBaseURL() {
        String baseURL = this.pathFinder.getBaseUrl();
        return this.getServerURL() + baseURL + "/";
    }

    @Nonnull
    public String getServerURL() {
        String protocol = this.getValue("system/server/protocol");
        String host = this.getValue("system/server/host");
        Integer port = this.getServerPort();
        StringBuffer sb = new StringBuffer(protocol + "://");
        sb.append(host);
        if (SettingManager.isPortRequired(protocol, "" + port)) {
            sb.append(":");
            sb.append(port);
        }
        return sb.toString();
    }

    public Integer getServerPort() {
        String protocol = this.getValue("system/server/protocol");
        Integer configuredPort = this.getValueAsInt("system/server/port", -1);
        Integer sitePort = configuredPort != -1 ? configuredPort : (protocol != null && protocol.equalsIgnoreCase("https") ? Integer.valueOf(443) : Integer.valueOf(80));
        return sitePort;
    }

    public static boolean isPortRequired(String protocol, String port) {
        if ("http".equals(protocol) && String.valueOf(80).equals(port)) {
            return false;
        }
        return !"https".equals(protocol) || !String.valueOf(443).equals(port);
    }

    private Integer toIntOrNull(String key) {
        try {
            return Integer.parseInt(this.getValue(key));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

