/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect.bearer;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.fao.geonet.kernel.security.openidconnect.OIDCConfiguration;
import org.fao.geonet.kernel.security.openidconnect.OIDCRoleProcessor;
import org.fao.geonet.kernel.security.openidconnect.bearer.AccessTokenParser;
import org.fao.geonet.kernel.security.openidconnect.bearer.AccessTokenValidator;
import org.fao.geonet.kernel.security.openidconnect.bearer.RoleInserter;
import org.fao.geonet.kernel.security.openidconnect.bearer.UserInfoCache;
import org.fao.geonet.kernel.security.openidconnect.bearer.UserInfoCacheItem;
import org.fao.geonet.kernel.security.openidconnect.bearer.UserRolesResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.util.Assert;

public class GeonetworkJwtAuthenticationProvider
implements AuthenticationProvider {
    static UserInfoCache userInfoCache = new UserInfoCache();
    private final OAuth2UserService<OidcUserRequest, OidcUser> userService;
    AccessTokenParser accessTokenParser;
    UserRolesResolver userRolesResolver;
    List<AccessTokenValidator> accessTokenValidators;
    @Autowired
    ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    OIDCRoleProcessor oidcRoleProcessor;
    @Autowired
    RoleHierarchy roleHierarchy;
    @Autowired
    OIDCConfiguration oidcConfiguration;
    @Autowired
    ClientRegistrationRepository clientRegistrationRepository;
    private OAuth2UserService<OAuth2UserRequest, OAuth2User> oauth2UserService = new DefaultOAuth2UserService();
    private Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter = new JwtAuthenticationConverter();
    private static final OAuth2Error DEFAULT_INVALID_TOKEN = GeonetworkJwtAuthenticationProvider.invalidToken("An error occurred while attempting to decode the Jwt: Invalid token");

    public GeonetworkJwtAuthenticationProvider(AccessTokenParser accessTokenParser, OAuth2UserService<OidcUserRequest, OidcUser> userService, UserRolesResolver userRolesResolver, List<AccessTokenValidator> accessTokenValidators) {
        Assert.notNull((Object)accessTokenParser, (String)"accessTokenParser cannot be null");
        Assert.notNull(userService, (String)"userService cannot be null");
        Assert.notNull(accessTokenValidators, (String)"accessTokenValidators cannot be null");
        this.userRolesResolver = userRolesResolver;
        this.accessTokenParser = accessTokenParser;
        this.userService = userService;
        this.accessTokenValidators = accessTokenValidators;
    }

    private static OAuth2Error invalidToken(String message) {
        try {
            return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, message, "https://tools.ietf.org/html/rfc6750#section-3.1");
        }
        catch (IllegalArgumentException malformed) {
            return DEFAULT_INVALID_TOKEN;
        }
    }

    public void verifyToken(Map claims, Map userInfoClaims) throws Exception {
        for (AccessTokenValidator validator : this.accessTokenValidators) {
            validator.verifyToken(claims, userInfoClaims);
        }
    }

    public UserInfoCacheItem createCacheItem(Authentication authentication) {
        Map jwt;
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        try {
            jwt = this.accessTokenParser.parseToken(bearer.getToken());
        }
        catch (Exception failed) {
            OAuth2Error invalidToken = GeonetworkJwtAuthenticationProvider.invalidToken(failed.getMessage());
            throw new OAuth2AuthenticationException(invalidToken, invalidToken.getDescription(), (Throwable)failed);
        }
        Instant expireTime = Instant.ofEpochMilli((Long)jwt.get("exp") * 1000L);
        if (expireTime.compareTo(Instant.now()) < 0) {
            throw new OAuth2AuthenticationException(GeonetworkJwtAuthenticationProvider.invalidToken("access token has expired"));
        }
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId("geonetwork-oidc");
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, bearer.getToken(), Instant.ofEpochMilli((Long)jwt.get("iat") * 1000L), Instant.ofEpochMilli((Long)jwt.get("exp") * 1000L));
        OAuth2UserRequest oAuth2UserRequest = new OAuth2UserRequest(clientRegistration, accessToken);
        OAuth2User oAuth2User = this.oauth2UserService.loadUser(oAuth2UserRequest);
        OidcUserInfo userInfo = new OidcUserInfo(oAuth2User.getAttributes());
        try {
            this.verifyToken(jwt, userInfo.getClaims());
        }
        catch (Exception failed) {
            OAuth2Error invalidToken = GeonetworkJwtAuthenticationProvider.invalidToken(failed.getMessage());
            throw new OAuth2AuthenticationException(invalidToken, invalidToken.getDescription(), (Throwable)failed);
        }
        List<String> userRoles = null;
        try {
            userRoles = this.userRolesResolver.resolveRoles(bearer.getToken(), jwt, userInfo);
            userInfo = RoleInserter.insertRoles(this.oidcConfiguration.getIdTokenRoleLocation(), userInfo, userRoles);
        }
        catch (Exception e) {
            throw new InternalAuthenticationServiceException("userRolesResolver.resolveRoles exception", (Throwable)e);
        }
        Collection<? extends GrantedAuthority> authorities = this.oidcRoleProcessor.createAuthorities(this.roleHierarchy, userRoles);
        DefaultOAuth2User user = new DefaultOAuth2User(authorities, userInfo.getClaims(), this.oidcConfiguration.getUserNameAttribute());
        return new UserInfoCacheItem(bearer.getToken(), expireTime, (OAuth2User)user, authorities);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.authenticate(authentication, "geonetwork-oidc");
    }

    public Authentication authenticate(Authentication authentication, String registrationName) throws AuthenticationException {
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        UserInfoCacheItem item = userInfoCache.getItem(bearer.getToken());
        if (item == null) {
            item = this.createCacheItem(authentication);
            userInfoCache.putItem(item);
        }
        OAuth2User user = item.getUser();
        Collection<? extends GrantedAuthority> authorities = item.getAuthorities();
        OAuth2AuthenticationToken authenticationResult = new OAuth2AuthenticationToken(user, authorities, registrationName);
        authenticationResult.setDetails(authentication.getDetails());
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent((Authentication)authenticationResult, this.getClass()));
        }
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

