/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.web.context.ServletContextAware;

public class GeonetworkOidcPreAuthActionsLoginFilter
implements Filter,
ServletContextAware {
    @Autowired
    private ClientRegistrationRepository clientRegistrationRepository;
    private static final String EXCLUDED_URL_PATHS = "excludedPaths";
    private List<AntPathRequestMatcher> excludedPathsMatchers = new ArrayList<AntPathRequestMatcher>();

    public void setServletContext(ServletContext servletContext) {
        String excludedPathsValue = servletContext.getInitParameter(EXCLUDED_URL_PATHS);
        if (StringUtils.isNotEmpty((CharSequence)excludedPathsValue)) {
            this.excludedPathsMatchers = Arrays.stream(excludedPathsValue.split(",")).map(StringUtils::trimToEmpty).filter(StringUtils::isNotEmpty).map(AntPathRequestMatcher::new).collect(Collectors.toList());
        }
        this.excludedPathsMatchers.add(new AntPathRequestMatcher("/.well-known/jwks.json"));
    }

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        HttpSession httpSession = servletRequest.getSession(false);
        String requestUri = servletRequest.getRequestURI();
        String contextPath = servletRequest.getContextPath();
        String clientRegistrationId = "geonetwork-oidc";
        String registrationId = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).getRegistrationId();
        String loginPath = contextPath + "/oauth2/authorization/" + registrationId;
        boolean isLoginRequest = requestUri.equals(loginPath);
        boolean isBearerTokenAccess = servletRequest.getHeader("Authorization") != null && servletRequest.getHeader("Authorization").startsWith("Bearer ");
        boolean isAuthenticated = SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().isAuthenticated() && !(SecurityContextHolder.getContext().getAuthentication() instanceof AnonymousAuthenticationToken) && httpSession != null;
        boolean isPublicEndpoint = this.excludedPathsMatchers.stream().anyMatch(matcher -> matcher.matches(servletRequest));
        if (!(isAuthenticated || isLoginRequest || isPublicEndpoint || isBearerTokenAccess)) {
            String returningUrl = requestUri + (String)(servletRequest.getQueryString() == null ? "" : "?" + servletRequest.getQueryString());
            String redirectUrl = loginPath + "?redirectUrl=" + URLEncoder.encode(returningUrl, Constants.ENCODING);
            servletResponse.sendRedirect(redirectUrl);
            return;
        }
        chain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    public void destroy() {
    }
}

