/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.jwtheaders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.utils.Log;
import org.geoserver.security.jwtheaders.JwtConfiguration;
import org.geoserver.security.jwtheaders.roles.JwtHeadersRolesExtractor;
import org.geoserver.security.jwtheaders.token.TokenValidator;
import org.geoserver.security.jwtheaders.username.JwtHeaderUserNameExtractor;
import org.springframework.util.StringUtils;

public class JwtHeadersTrivialUser {
    static String ROLE_GROUP_SEPARATOR = ":";
    static Profile MIN_PROFILE = Profile.RegisteredUser;
    Map<Profile, List<String>> profileGroups;
    private String username;
    private Profile profile;

    public JwtHeadersTrivialUser(String userName) {
        this.setUsername(userName);
        this.profileGroups = new HashMap<Profile, List<String>>();
    }

    public static JwtHeadersTrivialUser create(JwtConfiguration config, HttpServletRequest request) throws IOException {
        if (request == null || config == null || config.getUserNameHeaderAttributeName() == null) {
            Log.debug((String)"geonetwork.security", (Object)"JwtHeadersUser.create called with null args!");
            return null;
        }
        String userNameHeader = request.getHeader(config.getUserNameHeaderAttributeName());
        if (userNameHeader == null) {
            return null;
        }
        JwtHeaderUserNameExtractor userNameExtractor = new JwtHeaderUserNameExtractor(config);
        String userName = userNameExtractor.extractUserName(userNameHeader);
        if (userName == null) {
            return null;
        }
        TokenValidator tokenValidator = new TokenValidator(config);
        try {
            tokenValidator.validate(userNameHeader);
        }
        catch (Exception e) {
            throw new IOException("JWT Token is invalid", e);
        }
        JwtHeadersTrivialUser result = new JwtHeadersTrivialUser(userName);
        JwtHeadersTrivialUser.handleRoles(result, config, request);
        return result;
    }

    public static void handleRoles(JwtHeadersTrivialUser user, JwtConfiguration config, HttpServletRequest request) {
        if (!config.getJwtHeaderRoleSource().equals("JSON") && !config.getJwtHeaderRoleSource().equals("JWT")) {
            return;
        }
        if (config.getRolesHeaderName() == null) {
            return;
        }
        String rolesHeader = request.getHeader(config.getRolesHeaderName());
        JwtHeadersRolesExtractor rolesExtractor = new JwtHeadersRolesExtractor(config);
        Collection roles = rolesExtractor.getRoles(rolesHeader);
        JwtHeadersTrivialUser.updateUserWithRoles(user, roles);
    }

    public static void updateUserWithRoles(JwtHeadersTrivialUser user, Collection<String> roles) {
        Map<Profile, List<String>> profileGroups = JwtHeadersTrivialUser.extractProfileRoles(roles);
        if (profileGroups != null && profileGroups.size() > 0) {
            String profile = JwtHeadersTrivialUser.getMaxProfile(profileGroups).name();
            if (profile != null) {
                user.profile = Profile.valueOf((String)profile);
            }
        } else {
            user.profile = Profile.RegisteredUser;
        }
        user.profileGroups = profileGroups;
    }

    public static Map<Profile, List<String>> extractProfileRoles(Collection<String> rolesInToken) {
        HashMap<Profile, List<String>> profileGroups = new HashMap<Profile, List<String>>();
        HashSet<String> roleGroupList = new HashSet<String>();
        for (String role : rolesInToken) {
            if (role.contains(ROLE_GROUP_SEPARATOR)) {
                Log.debug((String)"geonetwork.security", (Object)("Identified group:profile (" + role + ") from user token."));
                roleGroupList.add(role);
                continue;
            }
            Profile p = Profile.findProfileIgnoreCase((String)role);
            if (p == null || profileGroups.containsKey(p)) continue;
            profileGroups.put(p, new ArrayList());
        }
        for (String rg : roleGroupList) {
            String[] rg_role_groups = rg.split(ROLE_GROUP_SEPARATOR);
            if (rg_role_groups.length == 0 || StringUtils.isEmpty((Object)rg_role_groups[0])) continue;
            Profile p = null;
            if (rg_role_groups.length >= 1) {
                p = Profile.findProfileIgnoreCase((String)rg_role_groups[1]);
            }
            if (p == null) continue;
            List groups = profileGroups.containsKey(p) ? (List)profileGroups.get(p) : new ArrayList();
            if (rg_role_groups.length > 1) {
                groups.add(rg_role_groups[0]);
            }
            profileGroups.put(p, groups);
        }
        return profileGroups;
    }

    public static Profile getMaxProfile(Map<Profile, List<String>> profileGroups) {
        Profile maxProfile = null;
        for (Profile p : profileGroups.keySet()) {
            if (maxProfile == null) {
                maxProfile = p;
                continue;
            }
            if (maxProfile.compareTo((Enum)p) < 0) continue;
            maxProfile = p;
        }
        if (maxProfile == null) {
            maxProfile = MIN_PROFILE;
        }
        return maxProfile;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Map<Profile, List<String>> getProfileGroups() {
        return this.profileGroups;
    }

    public void setProfileGroups(Map<Profile, List<String>> profileGroups) {
        this.profileGroups = profileGroups;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }
}

