/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Source;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.repository.SourceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsFilterBuilder {
    private static AccessManager accessManager;
    private static SourceRepository sourceRepository;

    @Autowired
    public EsFilterBuilder(AccessManager accessManager, SourceRepository sourceRepository) {
        EsFilterBuilder.sourceRepository = sourceRepository;
        EsFilterBuilder.accessManager = accessManager;
    }

    public static String buildPermissionsFilter(ServiceContext context) throws Exception {
        UserSession userSession = context.getUserSession();
        if (Profile.Administrator.equals((Object)userSession.getProfile())) {
            return "*:*";
        }
        Set<Integer> groups = accessManager.getUserGroups(userSession, context.getIpAddress(), false);
        String ids = groups.stream().map(Object::toString).map(e -> e.replace("-", "\\\\-")).collect(Collectors.joining(" OR "));
        String operationFilter = String.format("op%d:(%s)", ReservedOperation.view.getId(), ids);
        String ownerFilter = "";
        if (userSession.getUserIdAsInt() > 0) {
            ownerFilter = String.format("owner:%d", userSession.getUserIdAsInt());
        }
        return String.format("(%s %s)", operationFilter, ownerFilter).trim();
    }

    public static String build(ServiceContext context, String type, boolean isSearchingForDraft, NodeInfo node) throws Exception {
        String portalFilter;
        StringBuilder query = new StringBuilder();
        query.append(EsFilterBuilder.buildPermissionsFilter(context).trim());
        if (type.equalsIgnoreCase("metadata")) {
            query.append(" AND (isTemplate:n)");
        } else if (type.equalsIgnoreCase("template")) {
            query.append(" AND (isTemplate:y)");
        } else if (type.equalsIgnoreCase("subtemplate")) {
            query.append(" AND (isTemplate:s)");
        }
        if (!isSearchingForDraft) {
            query.append(" AND (draft:n OR draft:e)");
        }
        if (!"".equals(portalFilter = EsFilterBuilder.buildPortalFilter(node))) {
            query.append(" AND ").append(portalFilter);
        }
        return query.toString();
    }

    public static String buildPortalFilter(NodeInfo node) {
        Optional portal;
        if (node != null && !"srv".equals(node.getId()) && (portal = sourceRepository.findById((Object)node.getId())).isPresent() && StringUtils.isNotEmpty((String)((Source)portal.get()).getFilter())) {
            return ((Source)portal.get()).getFilter().replace("\"", "\\\"");
        }
        return "";
    }
}

