/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.AttributeEntry;
import org.fao.geonet.kernel.schema.BaseHandler;
import org.fao.geonet.kernel.schema.ElementEntry;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.jdom.Element;

class ComplexContentEntry
extends BaseHandler {
    public String base;
    public ArrayList<String> alAttribGroups = new ArrayList();
    public ArrayList<ElementEntry> alElements = new ArrayList();
    public ArrayList<AttributeEntry> alAttribs = new ArrayList();
    boolean restriction = false;

    public ComplexContentEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public ComplexContentEntry(ElementInfo ei) {
        this.handleAttribs(ei);
        this.handleChildren(ei);
    }

    private void handleAttribs(ElementInfo ei) {
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Element elChild : children) {
            if (elChild.getName().equals("extension")) {
                this.handleExtension(elChild, ei);
                continue;
            }
            if (elChild.getName().equals("restriction")) {
                this.handleRestriction(elChild, ei);
                this.restriction = true;
                continue;
            }
            Logger.log();
        }
    }

    private void handleExtension(Element el, ElementInfo ei) {
        this.base = el.getAttributeValue("base");
        List extension = el.getChildren();
        for (Element elExt : extension) {
            if (elExt.getName().equals("sequence")) {
                List sequence = elExt.getChildren();
                for (Element elSeq : sequence) {
                    if (this.isChoiceOrElementOrGroupOrSequence(elSeq)) {
                        this.alElements.add(new ElementEntry(elSeq, ei.file, ei.targetNS, ei.targetNSPrefix));
                        continue;
                    }
                    Logger.log();
                }
                continue;
            }
            if (elExt.getName().equals("group")) {
                this.alElements.add(new ElementEntry(elExt, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elExt.getName().equals("choice")) {
                this.alElements.add(new ElementEntry(elExt, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elExt.getName().equals("attribute")) {
                this.alAttribs.add(new AttributeEntry(elExt, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elExt.getName().equals("attributeGroup")) {
                String attribGroup = elExt.getAttributeValue("ref");
                if (attribGroup == null) {
                    throw new IllegalArgumentException("'ref' is null for element in <attributeGroup> of ComplexContent with extension base " + this.base);
                }
                this.alAttribGroups.add(attribGroup);
                continue;
            }
            Logger.log();
        }
    }

    private void handleRestriction(Element el, ElementInfo ei) {
        this.base = el.getAttributeValue("base");
        List restriction = el.getChildren();
        for (Element elRes : restriction) {
            String elName = elRes.getName();
            if (elRes.getName().equals("sequence")) {
                this.handleSequence(elRes, this.alElements, ei);
                continue;
            }
            if (elRes.getName().equals("group")) {
                this.alElements.add(new ElementEntry(elRes, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elName.equals("attribute")) {
                this.alAttribs.add(new AttributeEntry(elRes, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elName.equals("attributeGroup")) {
                String attribGroup = elRes.getAttributeValue("ref");
                if (attribGroup == null) {
                    throw new IllegalArgumentException("'ref' is null for element in <attributeGroup> of ComplexContent with restriction base " + this.base);
                }
                this.alAttribGroups.add(attribGroup);
                continue;
            }
            Logger.log();
        }
    }
}

