/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.fao.geonet.kernel.schema.SimpleTypeEntry;
import org.jdom.Attribute;
import org.jdom.Element;

class AttributeEntry {
    public String name;
    public String type;
    public String unqualifiedName;
    public String namespacePrefix;
    public String defValue;
    public String reference;
    public String form = "unqualified";
    public boolean required = false;
    public ArrayList<String> alValues = new ArrayList();
    public ArrayList<String> alTypes = new ArrayList();

    public AttributeEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public AttributeEntry(ElementInfo ei) {
        this.handleAttribs(ei);
        this.handleChildren(ei);
    }

    private void handleAttribs(ElementInfo ei) {
        List attribs = ei.element.getAttributes();
        for (Object attrib : attribs) {
            Attribute at = (Attribute)attrib;
            String attrName = at.getName();
            if (attrName.equals("name")) {
                this.unqualifiedName = this.name = at.getValue();
                if (ei.targetNSPrefix == null) continue;
                this.name = ei.targetNSPrefix + ":" + this.name;
                this.namespacePrefix = ei.targetNSPrefix;
                continue;
            }
            if (attrName.equals("default") || attrName.equals("fixed")) {
                this.defValue = at.getValue();
                continue;
            }
            if (attrName.equals("ref")) {
                this.reference = at.getValue();
                continue;
            }
            if (attrName.equals("use")) {
                this.required = "required".equals(at.getValue());
                continue;
            }
            if (attrName.equals("type")) {
                this.type = ei.element.getAttributeValue(attrName);
                continue;
            }
            if (attrName.equals("form")) {
                this.form = at.getValue();
                continue;
            }
            Logger.log();
        }
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Object aChildren : children) {
            Element elChild = (Element)aChildren;
            String elName = elChild.getName();
            if (elName.equals("simpleType")) {
                int j;
                SimpleTypeEntry ste = new SimpleTypeEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                for (j = 0; j < ste.alEnum.size(); ++j) {
                    this.alValues.add(ste.alEnum.get(j));
                }
                for (j = 0; j < ste.alTypes.size(); ++j) {
                    this.alTypes.add(ste.alTypes.get(j));
                }
                continue;
            }
            if (elName.equals("annotation")) continue;
            Logger.log();
        }
    }

    public String toString() {
        int j;
        StringBuffer sb = new StringBuffer();
        sb.append("AttributeEntry name:" + this.name + ", type:" + this.type + " [");
        for (j = 0; j < this.alValues.size(); ++j) {
            sb.append(this.alValues.get(j) + ",");
        }
        sb.append("], types:[");
        for (j = 0; j < this.alTypes.size(); ++j) {
            sb.append(this.alTypes.get(j) + ",");
        }
        sb.append("]");
        return sb.toString();
    }
}

