/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.rdf;

import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.rdf.ResultInterpreter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsTable;

public class Query<Q> {
    private String query;
    private ResultInterpreter<Q> interpreter;

    public Query(String query, ResultInterpreter<Q> interpreter) {
        this.query = query;
        this.interpreter = interpreter;
    }

    public QueryResultsTable rawExecute(Thesaurus thesaurus) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        return thesaurus.performRequest(this.query);
    }

    public List<Q> execute(Thesaurus thesaurus) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        QueryResultsTable table = this.rawExecute(thesaurus);
        return new QueryResults(table, thesaurus);
    }

    public String toString() {
        return "Query [query=" + this.query + ", interpreter=" + this.interpreter.getClass().getSimpleName() + "]";
    }

    public final class QueryResults
    extends AbstractList<Q>
    implements Serializable {
        private static final long serialVersionUID = 3968403559675441162L;
        private final QueryResultsTable table;
        private final transient Thesaurus thesaurus;

        public QueryResults(QueryResultsTable table, Thesaurus thesaurus) {
            this.table = table;
            this.thesaurus = thesaurus;
        }

        @Override
        public Q get(int index) {
            if (index > this.table.getRowCount() - 1) {
                throw new IndexOutOfBoundsException(index + " is greater than " + (this.table.getRowCount() - 1));
            }
            return Query.this.interpreter.createFromRow(this.thesaurus, this.table, index);
        }

        @Override
        public int size() {
            return this.table.getRowCount();
        }
    }
}

