/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public final class LocaleUtil {
    public static Locale toLocale(String langCode) {
        if (StringUtils.isEmpty((String)langCode)) {
            return Locale.getDefault();
        }
        if (langCode.length() < 2 || langCode.length() > 3) {
            throw new AssertionError((Object)(langCode + " must be a 2 or 3 letter ISO code"));
        }
        return LocaleUtil.toLocale(langCode, Locale.getDefault());
    }

    public static Locale toLocale(String langCode, Locale defaultLocale) {
        for (Locale loc : Locale.getAvailableLocales()) {
            if (!loc.getISO3Language().toLowerCase().startsWith(langCode)) continue;
            return loc;
        }
        return defaultLocale;
    }
}

