/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.exception.InputStreamLimitExceededException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.Sort;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.util.LimitedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractStore
implements Store {
    protected static final String RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_SEPARATOR = ":";
    protected static final String RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_ESCAPED_SEPARATOR = "\\:";
    private static final Logger log = LoggerFactory.getLogger(AbstractStore.class);
    @Value(value="${api.params.maxUploadSize}")
    protected long maxUploadSize;

    @Override
    public final List<MetadataResource> getResources(ServiceContext context, String metadataUuid, Sort sort, String filter) throws Exception {
        return this.getResources(context, metadataUuid, sort, filter, (Boolean)true);
    }

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, MetadataResourceVisibility metadataResourceVisibility, String filter) throws Exception {
        return this.getResources(context, metadataUuid, metadataResourceVisibility, filter, (Boolean)true);
    }

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, Sort sort, String filter, Boolean approved) throws Exception {
        int metadataId = AbstractStore.getAndCheckMetadataId(metadataUuid, approved);
        boolean canEdit = AbstractStore.getAccessManager(context).canEdit(context, String.valueOf(metadataId));
        ArrayList<MetadataResource> resourceList = new ArrayList<MetadataResource>(this.getResources(context, metadataUuid, MetadataResourceVisibility.PUBLIC, filter, approved));
        if (canEdit) {
            resourceList.addAll(this.getResources(context, metadataUuid, MetadataResourceVisibility.PRIVATE, filter, approved));
        }
        if (sort == Sort.name) {
            resourceList.sort(MetadataResourceVisibility.sortByFileName);
        }
        return resourceList;
    }

    @Override
    public final Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, String resourceId) throws Exception {
        return this.getResource(context, metadataUuid, resourceId, true);
    }

    @Override
    public final Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        try {
            return this.getResource(context, metadataUuid, MetadataResourceVisibility.PUBLIC, resourceId, approved);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return this.getResource(context, metadataUuid, MetadataResourceVisibility.PRIVATE, resourceId, approved);
        }
    }

    @Override
    public final MetadataResource getResourceMetadata(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        try {
            return this.getResourceMetadata(context, metadataUuid, MetadataResourceVisibility.PUBLIC, resourceId, approved);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return this.getResourceMetadata(context, metadataUuid, MetadataResourceVisibility.PRIVATE, resourceId, approved);
        }
    }

    @Override
    public Store.ResourceHolder getResourceWithRange(ServiceContext context, String metadataUuid, String resourceId, Boolean approved, long start, long end) throws Exception {
        try {
            return this.getResourceWithRange(context, metadataUuid, MetadataResourceVisibility.PUBLIC, resourceId, approved, start, end);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return this.getResourceWithRange(context, metadataUuid, MetadataResourceVisibility.PRIVATE, resourceId, approved, start, end);
        }
    }

    protected static AccessManager getAccessManager(ServiceContext context) {
        return (AccessManager)ApplicationContextHolder.get().getBean(AccessManager.class);
    }

    public static int getAndCheckMetadataId(String metadataUuid, Boolean approved) throws Exception {
        ConfigurableApplicationContext _appContext = ApplicationContextHolder.get();
        Object metadata = approved != false ? ((MetadataRepository)_appContext.getBean(MetadataRepository.class)).findOneByUuid(metadataUuid) : ((IMetadataUtils)_appContext.getBean(IMetadataUtils.class)).findOneByUuid(metadataUuid);
        if (metadata == null) {
            throw new ResourceNotFoundException(String.format("Metadata with UUID '%s' not found.", metadataUuid)).withMessageKey("exception.resourceNotFound.metadata").withDescriptionKey("exception.resourceNotFound.metadata.description", new String[]{metadataUuid});
        }
        return metadata.getId();
    }

    protected int canEdit(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        return this.canEdit(context, metadataUuid, null, approved);
    }

    protected int canEdit(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = AbstractStore.getAndCheckMetadataId(metadataUuid, approved);
        boolean canEdit = AbstractStore.getAccessManager(context).canEdit(context, String.valueOf(metadataId));
        if (visibility == null && !canEdit || visibility == MetadataResourceVisibility.PRIVATE && !canEdit) {
            throw new SecurityException(String.format("User '%s' does not have privileges to access '%s' resources for metadata '%s'.", context.getUserSession() != null ? context.getUserSession().getUsername() + "/" + context.getUserSession().getProfile() : "anonymous", visibility == null ? "any" : visibility, metadataUuid));
        }
        return metadataId;
    }

    protected int canDownload(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        boolean canDownload;
        int metadataId = AbstractStore.getAndCheckMetadataId(metadataUuid, approved);
        if (visibility == MetadataResourceVisibility.PRIVATE && !(canDownload = AbstractStore.getAccessManager(context).canDownload(context, String.valueOf(metadataId)))) {
            throw new SecurityException(String.format("Current user can't download resources for metadata '%s' and as such can't access the requested resource.", metadataUuid));
        }
        return metadataId;
    }

    protected String getFilenameFromUrl(URL fileUrl) {
        String fileName = FilenameUtils.getName((String)fileUrl.getPath());
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        fileName = URLDecoder.decode(fileName, StandardCharsets.UTF_8);
        return fileName;
    }

    @Override
    public final MetadataResource putResource(ServiceContext context, String metadataUuid, MultipartFile file, MetadataResourceVisibility visibility) throws Exception {
        return this.putResource(context, metadataUuid, file.getOriginalFilename(), file.getInputStream(), null, visibility, true);
    }

    @Override
    public final MetadataResource putResource(ServiceContext context, String metadataUuid, MultipartFile file, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        if (StringUtils.contains((CharSequence)file.getOriginalFilename(), (int)59)) {
            throw new NotAllowedException(String.format("Uploaded resource '%s' contains forbidden character ; for metadata '%s'.", file.getOriginalFilename(), metadataUuid));
        }
        return this.putResource(context, metadataUuid, file.getOriginalFilename(), file.getInputStream(), null, visibility, approved);
    }

    @Override
    public final MetadataResource putResource(ServiceContext context, String metadataUuid, Resource resource, MetadataResourceVisibility visibility) throws Exception {
        return this.putResource(context, metadataUuid, resource, visibility, (Boolean)true);
    }

    @Override
    public final MetadataResource putResource(ServiceContext context, String metadataUuid, Resource resource, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        try (InputStream is = resource.getInputStream();){
            MetadataResource metadataResource = this.putResource(context, metadataUuid, resource.getFilename(), is, null, visibility, approved);
            return metadataResource;
        }
    }

    @Override
    public final MetadataResource putResource(ServiceContext context, String metadataUuid, URL fileUrl, MetadataResourceVisibility visibility) throws Exception {
        return this.putResource(context, metadataUuid, fileUrl, visibility, (Boolean)true);
    }

    @Override
    public final MetadataResource putResource(ServiceContext context, String metadataUuid, URL fileUrl, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        long contentLength;
        HttpURLConnection connection = (HttpURLConnection)fileUrl.openConnection();
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Unexpected response code: " + responseCode);
        }
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        String filename = null;
        if (contentDisposition != null) {
            filename = ContentDisposition.parse((String)contentDisposition).getFilename();
        }
        if (filename == null || filename.isEmpty()) {
            filename = this.getFilenameFromUrl(fileUrl);
        }
        if ((contentLength = connection.getContentLengthLong()) > this.maxUploadSize) {
            throw new InputStreamLimitExceededException(this.maxUploadSize, contentLength);
        }
        try (LimitedInputStream is = new LimitedInputStream(connection.getInputStream(), this.maxUploadSize, contentLength);){
            MetadataResource metadataResource = this.putResource(context, metadataUuid, filename, (InputStream)((Object)is), null, visibility, approved);
            return metadataResource;
        }
    }

    @Override
    public String delResources(ServiceContext context, String metadataUuid) throws Exception {
        return this.delResources(context, metadataUuid, true);
    }

    @Override
    public String delResources(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        return this.delResources(context, metadataId);
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, String resourceId) throws Exception {
        return this.delResource(context, metadataUuid, resourceId, true);
    }

    @Override
    public MetadataResource patchResourceStatus(ServiceContext context, String metadataUuid, String resourceId, MetadataResourceVisibility metadataResourceVisibility) throws Exception {
        return this.patchResourceStatus(context, metadataUuid, resourceId, metadataResourceVisibility, true);
    }

    @Override
    public void copyResources(ServiceContext context, String sourceUuid, String targetUuid, MetadataResourceVisibility metadataResourceVisibility, boolean sourceApproved, boolean targetApproved) throws Exception {
        List<MetadataResource> resources = this.getResources(context, sourceUuid, metadataResourceVisibility, null, (Boolean)sourceApproved);
        for (MetadataResource resource : resources) {
            Store.ResourceHolder holder = this.getResource(context, sourceUuid, metadataResourceVisibility, resource.getFilename(), sourceApproved);
            try {
                this.putResource(context, targetUuid, holder.getResource(), metadataResourceVisibility, (Boolean)targetApproved);
            }
            finally {
                if (holder == null) continue;
                holder.close();
            }
        }
    }

    protected String getFilename(String metadataUuid, String resourceId) {
        String prefix = metadataUuid + "/attachments/";
        if (resourceId.startsWith(prefix)) {
            return resourceId.substring(prefix.length());
        }
        return resourceId;
    }

    protected void checkResourceId(String resourceId) {
        if (resourceId.contains("..") || resourceId.startsWith("/") || resourceId.startsWith("file:/")) {
            throw new SecurityException(String.format("Invalid resource identifier '%s'.", resourceId));
        }
    }

    @Override
    public Store.ResourceManagementExternalProperties getResourceManagementExternalProperties() {
        return new Store.ResourceManagementExternalProperties(){

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public String getWindowParameters() {
                return null;
            }

            @Override
            public boolean isModal() {
                return false;
            }

            @Override
            public boolean isFolderEnabled() {
                return false;
            }

            public String toString() {
                try {
                    return new ObjectMapper().writeValueAsString((Object)this);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error converting ResourceManagementExternalProperties to json", e);
                }
            }
        };
    }

    private String escapeResourceManagementExternalProperties(String value) {
        return value.replace(RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_SEPARATOR, RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_ESCAPED_SEPARATOR);
    }

    protected String getResourceManagementExternalPropertiesObjectId(String type, MetadataResourceVisibility visibility, Integer metadataId, String version, String resourceId) {
        return Base64.getEncoder().encodeToString((type + RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_SEPARATOR + this.escapeResourceManagementExternalProperties(visibility == null ? "" : visibility.toString().toLowerCase()) + RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_SEPARATOR + metadataId + RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_SEPARATOR + this.escapeResourceManagementExternalProperties(version == null ? "" : version) + RESOURCE_MANAGEMENT_EXTERNAL_PROPERTIES_SEPARATOR + this.escapeResourceManagementExternalProperties(resourceId)).getBytes());
    }
}

