/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.dispatchers.guiservices;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.GuiService;
import jeeves.server.dispatchers.guiservices.XmlCacheManager;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.utils.IO;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;

public class XmlFile
implements GuiService {
    private final String name;
    private final String file;
    private final Path base;
    private final String language;
    private final String defaultLang;
    private final boolean localized;

    public XmlFile(Element config, String defaultLanguage, boolean defaultLocalized) throws BadInputEx {
        Path basePath;
        this.defaultLang = defaultLanguage;
        this.name = Util.getAttrib((Element)config, (String)"name");
        this.file = Util.getAttrib((Element)config, (String)"file");
        String loc = Util.getAttrib((Element)config, (String)"base", (String)"loc");
        try {
            basePath = IO.toPath((URI)new URI(loc));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            basePath = IO.toPath((String)loc, (String[])new String[0]);
        }
        this.base = basePath;
        this.language = config.getAttributeValue("language");
        String local = config.getAttributeValue("localized");
        this.localized = local == null ? defaultLocalized : local.equals("true");
    }

    @Override
    public Element exec(Element response, ServiceContext context) throws Exception {
        String lang = context.getLanguage();
        return this.getXml((ApplicationContext)context.getApplicationContext(), lang, true);
    }

    public Element getXml(ApplicationContext context, String lang, boolean makeCopy) throws JDOMException, IOException {
        String preferedLanguage = this.language;
        if (this.localized || preferedLanguage == null) {
            preferedLanguage = lang;
        }
        if (preferedLanguage == null) {
            preferedLanguage = this.defaultLang;
        }
        Element element = ((XmlCacheManager)context.getBean(XmlCacheManager.class)).get(context, this.localized, this.base, this.file, preferedLanguage, this.defaultLang, makeCopy);
        element.setName(this.name);
        return element;
    }
}

