/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordConversion;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.configuration.api.RecordMappingInformationDBO;
import org.jzkit.configuration.api.RecordTransformerTypeInformationDBO;
import org.jzkit.search.util.RecordConversion.FragmentTransformationException;
import org.jzkit.search.util.RecordConversion.FragmentTransformer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Document;

public class FragmentTransformerService
implements ApplicationContextAware {
    private String template_source;
    private static String file_sep = System.getProperty("file.separator");
    private Map context = new HashMap();
    private Map type_register = new HashMap();
    private static Log log = LogFactory.getLog(FragmentTransformerService.class);
    private List all_transformations = new ArrayList();
    private ApplicationContext ctx;
    private Map known_schemas = new HashMap();
    private Map known_transformers = new HashMap();
    private TransformerFactory tFactory = TransformerFactory.newInstance();
    private DocumentBuilder docBuilder;
    private Configuration configuration = null;

    public FragmentTransformerService(Configuration configuration) {
        log.debug((Object)"new FragmentTransformerService");
        this.configuration = configuration;
    }

    public void init() {
        log.debug((Object)"FragmentTransformerService::init");
        try {
            Iterator i = this.configuration.getRegisteredConverterTypes();
            while (i.hasNext()) {
                Object o = i.next();
                RecordTransformerTypeInformationDBO rtti = (RecordTransformerTypeInformationDBO)o;
                this.registerType(rtti.getType(), rtti.getClassname());
            }
            i = this.configuration.getRegisteredRecordMappings();
            while (i.hasNext()) {
                RecordMappingInformationDBO rmi = (RecordMappingInformationDBO)i.next();
                this.registerMapping(rmi.getFromSpec(), rmi.getToSpec(), rmi.getType(), rmi.getResource());
            }
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            this.docBuilder = dfactory.newDocumentBuilder();
            this.context.put("DocBuilder", this.docBuilder);
            this.context.put("TransformerFactory", this.tFactory);
        }
        catch (ConfigurationException ce) {
            throw new RuntimeException(ce.toString());
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce.toString());
        }
    }

    public void setTemplateSource(String directory) {
        this.template_source = directory;
    }

    public void registerType(String type, String classname) {
        log.debug((Object)("Register Type " + type + " class=" + classname));
        try {
            Class<?> c = Class.forName(classname);
            this.type_register.put(type, c);
        }
        catch (Exception e) {
            log.warn((Object)"Problem: ", (Throwable)e);
            throw new RuntimeException("Problem with transformer class", e);
        }
    }

    public void registerMapping(String from, String to, String type, String sheet) {
        log.debug((Object)("from " + from + " to " + to + " sheet=" + sheet + " type=" + type));
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("Sheet", sheet);
            Class required_type = (Class)this.type_register.get(type);
            if (required_type != null) {
                Class[] param_types = new Class[]{String.class, String.class, Map.class, Map.class, ApplicationContext.class};
                Constructor c = required_type.getConstructor(param_types);
                if (c != null) {
                    Object[] params = new Object[]{from, to, props, this.context, this.ctx};
                    FragmentTransformer t = (FragmentTransformer)c.newInstance(params);
                    this.all_transformations.add(t);
                } else {
                    log.error((Object)("No constructor available for class " + required_type.getName()));
                }
            } else {
                log.error((Object)("Unable to resolve a class for mapping " + type));
            }
        }
        catch (Exception e) {
            log.error((Object)("Problem registering mapping " + sheet + ". Mapping will not be available"), (Throwable)e);
        }
    }

    public Object convert(Document source, String from_schema, String to_schema, Map trans_properties) throws FragmentTransformationException {
        if (source == null) {
            throw new FragmentTransformationException("No source record for transformation");
        }
        Object result = source;
        Document next_input = source;
        log.debug((Object)("Attempting to find transform from " + from_schema + " to " + to_schema));
        List templates = this.findTransformationSequence(from_schema, to_schema);
        if (templates == null) {
            throw new FragmentTransformationException("No transformation templates available (trying " + from_schema + " to " + to_schema + ")");
        }
        log.debug((Object)("Located path : " + templates));
        Iterator templates_enum = templates.iterator();
        while (templates_enum.hasNext()) {
            FragmentTransformer transformation = (FragmentTransformer)templates_enum.next();
            result = transformation.transform(next_input, trans_properties);
            if (!templates_enum.hasNext() || !(result instanceof Document)) continue;
            next_input = (Document)result;
        }
        return result;
    }

    public List lookupTransformersMatchingSource(List path_so_far, String source) {
        ArrayList<FragmentTransformer> retval = new ArrayList<FragmentTransformer>();
        log.debug((Object)("lookupTransformersMatchingSource sz=" + this.all_transformations.size() + " src=" + source));
        for (FragmentTransformer ft : this.all_transformations) {
            if (path_so_far != null && path_so_far.contains(ft)) {
                log.warn((Object)("CYCLE DETECTED in transformation graph.. not re-adding target " + ft.getToSchema()));
                continue;
            }
            if (!ft.isApplicableTo(source)) continue;
            log.debug((Object)("Adding transform to " + ft.getToSchema()));
            retval.add(ft);
        }
        log.debug((Object)("lookupTransformersMatchingSource result=" + retval.size()));
        return retval;
    }

    public List findTransformationSequence(String source, String target) {
        ArrayList possible_transform_sequences = new ArrayList();
        List possible_transforms_from_source = this.lookupTransformersMatchingSource(null, source);
        Iterator e = possible_transforms_from_source.iterator();
        while (e.hasNext()) {
            ArrayList new_path = new ArrayList();
            new_path.add(e.next());
            possible_transform_sequences.add(new_path);
        }
        return this.breadthFirst(target, possible_transform_sequences);
    }

    public List breadthFirst(String target, List possible_transformation_set) {
        List result = null;
        if (possible_transformation_set == null || possible_transformation_set.size() == 0) {
            return null;
        }
        for (List current_path : possible_transformation_set) {
            FragmentTransformer ft = (FragmentTransformer)current_path.get(current_path.size() - 1);
            if (!ft.getToSchema().equalsIgnoreCase(target)) continue;
            result = current_path;
        }
        if (result != null) {
            return result;
        }
        ArrayList new_transformation_set = new ArrayList();
        for (List current_path_to_expand : possible_transformation_set) {
            FragmentTransformer ft = (FragmentTransformer)current_path_to_expand.get(current_path_to_expand.size() - 1);
            List possible_next_steps = this.lookupTransformersMatchingSource(current_path_to_expand, ft.getToSchema());
            Iterator e3 = possible_next_steps.iterator();
            while (e3.hasNext()) {
                ArrayList new_path = new ArrayList();
                new_path.addAll(current_path_to_expand);
                new_path.add(e3.next());
                new_transformation_set.add(new_path);
            }
        }
        return this.breadthFirst(target, new_transformation_set);
    }

    public Reference getReference() throws NamingException {
        return new Reference(FragmentTransformerService.class.getName());
    }

    public DOMResult createEmptyDOMResult() {
        return new DOMResult(this.docBuilder.newDocument());
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }
}

