/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.configuration.provider.db;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.CachedXPathAPI;
import org.jzkit.configuration.api.CollectionDefDTO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.configuration.api.SearchServiceDTO;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DbConfigSyncTool {
    public static Log log = LogFactory.getLog(DbConfigSyncTool.class);
    public static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    public String p_config_file = null;
    public Configuration p_config = null;

    public void setConfigFile(String config_file) {
        log.debug((Object)("Set config file " + config_file));
        this.p_config_file = config_file;
    }

    public void setConfiguration(Configuration config) {
        log.debug((Object)"Set jzkit config");
        this.p_config = config;
    }

    public void sync() {
        DbConfigSyncTool.sync(this.p_config_file, this.p_config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync(String config_file, Configuration config) {
        block18: {
            try {
                URL config_url = DbConfigSyncTool.class.getResource(config_file);
                log.debug((Object)("Attempting to load config from " + config_url + "(" + config_file + ")"));
                if (config_url != null) {
                    CachedXPathAPI api = new CachedXPathAPI();
                    dbf.setValidating(false);
                    DocumentBuilder parser = dbf.newDocumentBuilder();
                    Document document = parser.parse(config_url.openStream());
                    NodeList services = api.selectNodeList((Node)document, "/ServiceDirectory/SearchService");
                    for (int i = 0; i < services.getLength(); ++i) {
                        Element service = (Element)services.item(i);
                        SearchServiceDTO ss_dto = new SearchServiceDTO();
                        ss_dto.svc_class = service.getAttribute("className");
                        ss_dto.svc_code = service.getAttribute("code");
                        ss_dto.svc_name = service.getAttribute("serviceName");
                        log.debug((Object)("Adding service " + ss_dto.svc_code + " - " + ss_dto.svc_name + " - " + ss_dto.svc_class));
                        NodeList prefs = api.selectNodeList((Node)service, "./Preferences/Preference");
                        for (int i2 = 0; i2 < prefs.getLength(); ++i2) {
                            Element pref = (Element)prefs.item(i2);
                            Node val_node = api.selectSingleNode((Node)pref, "./text()");
                            ss_dto.properties.put(pref.getAttribute("name"), val_node.getNodeValue());
                            log.debug((Object)("Property " + pref.getAttribute("name") + " = " + val_node.getNodeValue()));
                        }
                        NodeList archetypes = api.selectNodeList((Node)service, "./RecordArchetypes/Archetype");
                        for (int i3 = 0; i3 < archetypes.getLength(); ++i3) {
                            Element arch = (Element)archetypes.item(i3);
                            Node val_node = api.selectSingleNode((Node)arch, "./text()");
                            ss_dto.archetypes.put(arch.getAttribute("name"), val_node.getNodeValue());
                            log.debug((Object)("Archetype " + arch.getAttribute("name") + " = " + val_node.getNodeValue()));
                        }
                        NodeList collections = api.selectNodeList((Node)service, "./Collections/Collection");
                        for (int i4 = 0; i4 < collections.getLength(); ++i4) {
                            Element coll = (Element)collections.item(i4);
                            if (coll != null) {
                                CollectionDefDTO coll_def = new CollectionDefDTO();
                                coll_def.code = coll.getAttribute("code");
                                coll_def.name = coll.getAttribute("name");
                                coll_def.localid = coll.getAttribute("localId");
                                coll_def.profile = coll.getAttribute("profile");
                                ss_dto.collections.add(coll_def);
                                continue;
                            }
                            log.error((Object)"Coll element was null");
                        }
                        NodeList indexes = api.selectNodeList((Node)service, "./ValidIndexes/Index");
                        for (int i5 = 0; i5 < indexes.getLength(); ++i5) {
                            Element idx = (Element)indexes.item(i5);
                            Node val_node = api.selectSingleNode((Node)idx, "./text()");
                            if (idx != null) {
                                HashSet<AttrValue> valid_attrs_of_type = ss_dto.valid_indexes.get(idx.getAttribute("type"));
                                if (valid_attrs_of_type == null) {
                                    valid_attrs_of_type = new HashSet<AttrValue>();
                                    ss_dto.valid_indexes.put(idx.getAttribute("type"), valid_attrs_of_type);
                                }
                                AttrValue valid_av = new AttrValue(idx.getAttribute("context"), val_node.getNodeValue());
                                valid_attrs_of_type.add(valid_av);
                                log.debug((Object)("Added valid attr of type " + idx.getAttribute("type") + " : " + valid_av));
                                continue;
                            }
                            log.error((Object)"Coll element was null");
                        }
                        NodeList translations = api.selectNodeList((Node)service, "./TargetSpecificTranslations/Translate");
                        for (int i6 = 0; i6 < translations.getLength(); ++i6) {
                            Element trans = (Element)translations.item(i6);
                            ss_dto.translations.put(trans.getAttribute("qualIndex"), trans.getAttribute("toIndex"));
                        }
                        config.addOrUpdate(ss_dto);
                    }
                    break block18;
                }
                log.warn((Object)"Unable to load configuration from XML");
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
            catch (TransformerException te) {
                te.printStackTrace();
            }
            catch (ConfigurationException ce) {
                ce.printStackTrace();
            }
        }
    }
}

