/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;
import java.io.Serializable;

public class ShortRange
implements Comparable,
Serializable {
    private short first;
    private short last;

    public ShortRange(short first, short last) {
        if (last < first) {
            Exceptions.invalidRangeBounds(String.valueOf(first), String.valueOf(last));
        }
        this.first = first;
        this.last = last;
    }

    public short first() {
        return this.first;
    }

    public short last() {
        return this.last;
    }

    public int length() {
        return this.last - this.first + 1;
    }

    public boolean intersects(ShortRange range) {
        return this.first >= range.first && this.first <= range.last || range.first >= this.first && range.first <= this.last;
    }

    public boolean adjacentTo(ShortRange range) {
        return this.last + 1 == range.first || range.last + 1 == this.first;
    }

    public boolean canMergeWith(ShortRange range) {
        return this.intersects(range) || this.adjacentTo(range);
    }

    public ShortRange mergeWith(ShortRange range) {
        if (!this.canMergeWith(range)) {
            Exceptions.cannotMergeRanges(this, range);
        }
        return this.quickMergeWith(range);
    }

    private ShortRange quickMergeWith(ShortRange range) {
        short nfirst = this.first < range.first ? this.first : range.first;
        short nlast = this.last > range.last ? this.last : range.last;
        return new ShortRange(nfirst, nlast);
    }

    public ShortRange tryMergeWith(ShortRange range) {
        if (!this.canMergeWith(range)) {
            return null;
        }
        return this.quickMergeWith(range);
    }

    public int intersectionLength(ShortRange range) {
        int len;
        if (this.first >= range.first && this.first <= range.last) {
            short end = this.last <= range.last ? this.last : range.last;
            len = end - this.first + 1;
        } else if (range.first >= this.first && range.first <= this.last) {
            short end = this.last <= range.last ? this.last : range.last;
            len = end - range.first + 1;
        } else {
            len = 0;
        }
        return len;
    }

    public boolean contains(short v) {
        return v >= this.first && v <= this.last;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortRange)) {
            return false;
        }
        ShortRange range = (ShortRange)obj;
        return this.first == range.first && this.last == range.last;
    }

    public int compareTo(Object obj) {
        ShortRange range = (ShortRange)obj;
        if (this.first < range.first) {
            return -1;
        }
        if (this.first > range.first) {
            return 1;
        }
        if (this.last < range.last) {
            return -1;
        }
        if (this.last > range.last) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.first ^ this.last;
    }

    public String toString() {
        return Display.display(this.first) + "-" + Display.display(this.last);
    }
}

