/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.ByteCollection;
import bak.pcj.ByteIterator;
import bak.pcj.set.AbstractByteSet;
import bak.pcj.set.ByteSortedSet;
import bak.pcj.util.Exceptions;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class ByteBitSet
extends AbstractByteSet
implements ByteSortedSet,
Cloneable,
Serializable {
    private static final int BITS_PER_LONG = 64;
    private static final int BIT_MASK = 63;
    private static final int BIT_MASK_BITS = 6;
    private static final int DEFAULT_CAPACITY = 64;
    private long[] data;
    private int size;

    public ByteBitSet(byte maximum) {
        if (maximum < 0) {
            Exceptions.negativeArgument("maximum", String.valueOf(maximum));
        }
        this.data = new long[1 + ByteBitSet.longIndex(maximum)];
        this.size = 0;
    }

    public ByteBitSet() {
        this(64);
    }

    public ByteBitSet(ByteCollection c) {
        this();
        this.addAll(c);
    }

    public ByteBitSet(byte[] a) {
        this(ByteBitSet.amax(a));
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    private static byte amax(byte[] a) {
        byte max = 0;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    private static int longIndex(int index) {
        return index >> 6;
    }

    private static int bitIndex(int index) {
        return index & 0x3F;
    }

    private static long bit(int bitno) {
        return 1L << bitno;
    }

    private static int largestBitIndexOf(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException("No elements left");
        }
        int bitIndex = 63;
        long bit = 1L << bitIndex;
        while ((v & bit) == 0L) {
            --bitIndex;
            bit >>= 1;
        }
        return bitIndex;
    }

    private static int smallestBitIndexOf(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException("No elements left");
        }
        int bitIndex = 0;
        long bit = 1L;
        while ((v & bit) == 0L) {
            ++bitIndex;
            bit <<= 1;
        }
        return bitIndex;
    }

    private static int countBits(long v) {
        int count = 0;
        int bitIndex = 0;
        long bit = 1L;
        do {
            if ((v & bit) != 0L) {
                ++count;
            }
            bit <<= 1;
        } while (++bitIndex < 64);
        return count;
    }

    private static long lowMask(int n) {
        long v = 0L;
        int i = 0;
        while (i < n) {
            v = v << 1 | 1L;
            ++i;
        }
        return v;
    }

    private static long highMask(int n) {
        return ByteBitSet.lowMask(n) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void ensureCapacity(int maximum) {
        int newcapacity;
        if (maximum < 0) {
            Exceptions.negativeArgument("maximum", String.valueOf(maximum));
        }
        if (this.data.length < (newcapacity = 1 + ByteBitSet.longIndex(maximum))) {
            long[] newdata = new long[newcapacity];
            System.arraycopy(this.data, 0, newdata, 0, this.data.length);
            this.data = newdata;
        }
    }

    public boolean add(byte value) {
        long bit;
        boolean result;
        int longIndex;
        if (value < 0) {
            Exceptions.negativeArgument("value", String.valueOf(value));
        }
        if (this.data.length < 1 + (longIndex = ByteBitSet.longIndex(value))) {
            this.ensureCapacity(value);
        }
        boolean bl = result = (this.data[longIndex] & (bit = ByteBitSet.bit(ByteBitSet.bitIndex(value)))) == 0L;
        if (result) {
            ++this.size;
        }
        int n = longIndex;
        this.data[n] = this.data[n] | bit;
        return result;
    }

    public ByteIterator iterator() {
        if (this.size == 0) {
            return new ByteIterator(){

                public boolean hasNext() {
                    return false;
                }

                public byte next() {
                    Exceptions.endOfIterator();
                    throw new RuntimeException();
                }

                public void remove() {
                    Exceptions.noElementToRemove();
                }
            };
        }
        return new ByteIterator(){
            int nextLongIndex = this.nextLongIndex(0);
            int nextBitIndex = this.nextLongIndex < ByteBitSet.access$000(ByteBitSet.this).length ? this.nextBitIndex(this.nextLongIndex, 0) : 0;
            int lastValue = -1;

            int nextLongIndex(int index) {
                while (index < ByteBitSet.this.data.length && ByteBitSet.this.data[index] == 0L) {
                    ++index;
                }
                return index;
            }

            int nextBitIndex(int longIndex, int bitIndex) {
                long v = ByteBitSet.this.data[longIndex];
                long bit = 1L << bitIndex;
                while (bitIndex < 64 && (v & bit) == 0L) {
                    ++bitIndex;
                    bit <<= 1;
                }
                return bitIndex;
            }

            public boolean hasNext() {
                return this.nextLongIndex < ByteBitSet.this.data.length;
            }

            public byte next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (byte)(this.nextLongIndex * 64 + this.nextBitIndex);
                this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, this.nextBitIndex + 1);
                if (this.nextBitIndex == 64) {
                    this.nextLongIndex = this.nextLongIndex(this.nextLongIndex + 1);
                    if (this.nextLongIndex < ByteBitSet.this.data.length) {
                        this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, 0);
                    }
                }
                return (byte)this.lastValue;
            }

            public void remove() {
                if (this.lastValue < 0) {
                    Exceptions.noElementToRemove();
                }
                ByteBitSet.this.remove((byte)this.lastValue);
                this.lastValue = -1;
            }
        };
    }

    public void trimToSize() {
        int n = this.data.length - 1;
        while (n >= 0 && this.data[n] == 0L) {
            --n;
        }
        if (n < this.data.length - 1) {
            long[] newdata = new long[1 + n];
            System.arraycopy(this.data, 0, newdata, 0, newdata.length);
            this.data = newdata;
        }
    }

    public Object clone() {
        try {
            ByteBitSet c = (ByteBitSet)super.clone();
            c.data = new long[this.data.length];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = 0L;
            ++i;
        }
        this.size = 0;
    }

    public boolean contains(byte value) {
        if (value < 0) {
            return false;
        }
        int longIndex = ByteBitSet.longIndex(value);
        if (longIndex >= this.data.length) {
            return false;
        }
        long bit = ByteBitSet.bit(ByteBitSet.bitIndex(value));
        return (this.data[longIndex] & bit) != 0L;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean remove(byte value) {
        boolean result;
        if (value < 0) {
            return false;
        }
        int longIndex = ByteBitSet.longIndex(value);
        if (longIndex >= this.data.length) {
            return false;
        }
        long bit = ByteBitSet.bit(ByteBitSet.bitIndex(value));
        boolean bl = result = (this.data[longIndex] & bit) != 0L;
        if (result) {
            --this.size;
        }
        int n = longIndex;
        this.data[n] = this.data[n] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public int size() {
        return this.size;
    }

    private byte firstFrom(byte from) {
        int longIndex;
        if (this.size == 0) {
            Exceptions.setNoFirst();
        }
        if ((longIndex = ByteBitSet.longIndex(from)) >= this.data.length) {
            Exceptions.setNoFirst();
        }
        long v = this.data[longIndex];
        v &= ByteBitSet.highMask(ByteBitSet.bitIndex(from));
        try {
            while (true) {
                if (v != 0L) {
                    int bitIndex = ByteBitSet.smallestBitIndexOf(v);
                    return (byte)(64 * longIndex + bitIndex);
                }
                v = this.data[++longIndex];
            }
        }
        catch (IndexOutOfBoundsException e) {
            Exceptions.setNoFirst();
            throw new RuntimeException();
        }
    }

    public byte first() {
        return this.firstFrom((byte)0);
    }

    private byte lastFrom(byte from) {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        int longIndex = Math.min(ByteBitSet.longIndex(from), this.data.length - 1);
        long v = this.data[longIndex];
        v &= ByteBitSet.lowMask(ByteBitSet.bitIndex(from) + 1);
        try {
            while (true) {
                if (v != 0L) {
                    int bitIndex = ByteBitSet.largestBitIndexOf(v);
                    return (byte)(64 * longIndex + bitIndex);
                }
                v = this.data[--longIndex];
            }
        }
        catch (IndexOutOfBoundsException e) {
            Exceptions.setNoLast();
            throw new RuntimeException();
        }
    }

    public byte last() {
        if (this.size == 0) {
            Exceptions.setNoLast();
        }
        int longIndex = this.data.length - 1;
        while (this.data[longIndex] == 0L) {
            --longIndex;
        }
        long v = this.data[longIndex];
        int bitIndex = 63;
        long bit = 1L << bitIndex;
        while ((v & bit) == 0L) {
            --bitIndex;
            bit >>= 1;
        }
        return (byte)(64 * longIndex + bitIndex);
    }

    public ByteSortedSet headSet(byte to) {
        return new SubSet(false, 0, true, to);
    }

    public ByteSortedSet tailSet(byte from) {
        return new SubSet(true, from, false, 0);
    }

    public ByteSortedSet subSet(byte from, byte to) {
        return new SubSet(true, from, true, to);
    }

    private class SubSet
    extends AbstractByteSet
    implements ByteSortedSet,
    Serializable {
        private boolean hasLowerBound;
        private boolean hasUpperBound;
        private byte lowerBound;
        private byte upperBound;

        SubSet(boolean hasLowerBound, byte lowerBound, boolean hasUpperBound, byte upperBound) {
            if (hasLowerBound) {
                if (lowerBound < 0) {
                    Exceptions.negativeArgument("lower bound", String.valueOf(lowerBound));
                }
                if (hasUpperBound && upperBound < lowerBound) {
                    Exceptions.invalidSetBounds(String.valueOf(lowerBound), String.valueOf(upperBound));
                }
            }
            this.hasLowerBound = hasLowerBound;
            this.lowerBound = lowerBound;
            this.hasUpperBound = hasUpperBound;
            this.upperBound = upperBound;
        }

        public boolean add(byte v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ByteBitSet.this.add(v);
        }

        public boolean remove(byte v) {
            if (!this.inSubRange(v)) {
                Exceptions.valueNotInSubRange(String.valueOf(v));
            }
            return ByteBitSet.this.remove(v);
        }

        public boolean contains(byte v) {
            return this.inSubRange(v) && ByteBitSet.this.contains(v);
        }

        public ByteIterator iterator() {
            return new SubSetIterator();
        }

        public int size() {
            int size;
            int longIndexLow;
            if (ByteBitSet.this.size() == 0) {
                return 0;
            }
            try {
                longIndexLow = ByteBitSet.longIndex(this.first());
            }
            catch (NoSuchElementException e) {
                return 0;
            }
            int longIndexHigh = ByteBitSet.longIndex(this.last());
            if (longIndexLow == longIndexHigh) {
                long v = ByteBitSet.this.data[longIndexLow];
                if (this.hasLowerBound) {
                    v &= ByteBitSet.highMask(ByteBitSet.bitIndex(this.lowerBound));
                }
                if (this.hasUpperBound) {
                    v &= ByteBitSet.lowMask(ByteBitSet.bitIndex(this.upperBound));
                }
                size = ByteBitSet.countBits(v);
            } else {
                long vLow = ByteBitSet.this.data[longIndexLow];
                if (this.hasLowerBound) {
                    vLow &= ByteBitSet.highMask(ByteBitSet.bitIndex(this.lowerBound));
                }
                long vHigh = ByteBitSet.this.data[longIndexHigh];
                if (this.hasUpperBound) {
                    vHigh &= ByteBitSet.lowMask(ByteBitSet.bitIndex(this.upperBound));
                }
                size = ByteBitSet.countBits(vLow) + ByteBitSet.countBits(vHigh);
                int i = longIndexLow + 1;
                while (i < longIndexHigh) {
                    size += ByteBitSet.countBits(ByteBitSet.this.data[i]);
                    ++i;
                }
            }
            return size;
        }

        public byte first() {
            byte first = ByteBitSet.this.firstFrom(this.hasLowerBound ? this.lowerBound : (byte)0);
            if (this.hasUpperBound && first >= this.upperBound) {
                Exceptions.setNoFirst();
            }
            return first;
        }

        public byte last() {
            byte last = ByteBitSet.this.lastFrom(this.hasUpperBound ? (byte)(this.upperBound - 1) : ByteBitSet.this.last());
            if (this.hasLowerBound && last < this.lowerBound) {
                Exceptions.setNoLast();
            }
            return last;
        }

        public ByteSortedSet headSet(byte to) {
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(this.hasLowerBound, this.lowerBound, true, to);
        }

        public ByteSortedSet tailSet(byte from) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            return new SubSet(true, from, this.hasUpperBound, this.upperBound);
        }

        public ByteSortedSet subSet(byte from, byte to) {
            if (!this.inSubRange(from)) {
                Exceptions.invalidLowerBound(String.valueOf(from));
            }
            if (!this.inSubRange(to)) {
                Exceptions.invalidUpperBound(String.valueOf(to));
            }
            return new SubSet(true, from, true, to);
        }

        private boolean inSubRange(byte v) {
            if (this.hasLowerBound && v < this.lowerBound) {
                return false;
            }
            return !this.hasUpperBound || v < this.upperBound;
        }

        class SubSetIterator
        implements ByteIterator {
            int longIndexLow;
            int longIndexHigh;
            long vLow;
            long vHigh;
            boolean isEmpty = false;
            int nextLongIndex;
            int nextBitIndex;
            int lastValue = -1;

            SubSetIterator() {
                try {
                    this.longIndexLow = ByteBitSet.longIndex(SubSet.this.first());
                }
                catch (NoSuchElementException e) {
                    this.isEmpty = true;
                }
                if (!this.isEmpty) {
                    this.longIndexHigh = ByteBitSet.longIndex(SubSet.this.last());
                    if (this.longIndexLow == this.longIndexHigh) {
                        long v = ByteBitSet.this.data[this.longIndexLow];
                        if (SubSet.this.hasLowerBound) {
                            v &= ByteBitSet.highMask(ByteBitSet.bitIndex(SubSet.this.lowerBound));
                        }
                        if (SubSet.this.hasUpperBound) {
                            v &= ByteBitSet.lowMask(ByteBitSet.bitIndex(SubSet.this.upperBound));
                        }
                        ByteBitSet.this.size = ByteBitSet.countBits(v);
                        this.vLow = this.vHigh = v;
                    } else {
                        this.vLow = ByteBitSet.this.data[this.longIndexLow];
                        if (SubSet.this.hasLowerBound) {
                            this.vLow &= ByteBitSet.highMask(ByteBitSet.bitIndex(SubSet.this.lowerBound));
                        }
                        this.vHigh = ByteBitSet.this.data[this.longIndexHigh];
                        if (SubSet.this.hasUpperBound) {
                            this.vHigh &= ByteBitSet.lowMask(ByteBitSet.bitIndex(SubSet.this.upperBound));
                        }
                    }
                    this.nextLongIndex = this.longIndexLow;
                    this.nextBitIndex = ByteBitSet.smallestBitIndexOf(this.vLow);
                }
            }

            long data(int longIndex) {
                if (longIndex == this.longIndexLow) {
                    return this.vLow;
                }
                if (longIndex == this.longIndexHigh) {
                    return this.vHigh;
                }
                return ByteBitSet.this.data[longIndex];
            }

            int nextLongIndex(int index) {
                while (index <= this.longIndexHigh && this.data(index) == 0L) {
                    ++index;
                }
                return index;
            }

            int nextBitIndex(int longIndex, int bitIndex) {
                long v = this.data(longIndex);
                long bit = 1L << bitIndex;
                while (bitIndex < 64 && (v & bit) == 0L) {
                    ++bitIndex;
                    bit <<= 1;
                }
                return bitIndex;
            }

            public boolean hasNext() {
                return !this.isEmpty && this.nextLongIndex <= this.longIndexHigh;
            }

            public byte next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastValue = (byte)(this.nextLongIndex * 64 + this.nextBitIndex);
                this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, this.nextBitIndex + 1);
                if (this.nextBitIndex == 64) {
                    this.nextLongIndex = this.nextLongIndex(this.nextLongIndex + 1);
                    if (this.nextLongIndex < ByteBitSet.this.data.length) {
                        this.nextBitIndex = this.nextBitIndex(this.nextLongIndex, 0);
                    }
                }
                return (byte)this.lastValue;
            }

            public void remove() {
                if (this.lastValue < 0) {
                    Exceptions.noElementToRemove();
                }
                ByteBitSet.this.remove((byte)this.lastValue);
                this.lastValue = -1;
            }
        }
    }
}

