/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.CharCollection;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.map.LongKeyCharMap;
import bak.pcj.map.LongKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongKeyCharMap
implements LongKeyCharMap {
    protected AbstractLongKeyCharMap() {
    }

    public void clear() {
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public char remove(long key) {
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            char value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultChar();
    }

    public void putAll(LongKeyCharMap map) {
        LongKeyCharMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(long key) {
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public char get(long key) {
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultChar();
    }

    public boolean containsValue(char value) {
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongKeyCharMap)) {
            return false;
        }
        LongKeyCharMap map = (LongKeyCharMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            long k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultLongHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultCharHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public char tget(long key) {
        char value = this.get(key);
        if (value == MapDefaults.defaultChar() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongKeyCharMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract CharCollection values();

    public abstract char put(long var1, char var3);

    public abstract char lget();

    public abstract LongSet keySet();

    public abstract LongKeyCharMapIterator entries();
}

