/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractLongCollection;
import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.list.LongList;
import bak.pcj.list.LongListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList {
    protected AbstractLongList() {
    }

    public boolean add(long v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, long v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, LongCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        LongIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(long c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, long c) {
        LongListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public LongIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(long c) {
        LongListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, long c) {
        LongListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    public LongListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new LongListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractLongList.this.size();
            }

            public long next() {
                if (this.ptr == AbstractLongList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractLongList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractLongList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(long v) {
                AbstractLongList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public long previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractLongList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(long v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractLongList.this.set(this.lptr, v);
            }
        };
    }

    public long removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongList)) {
            return false;
        }
        LongListIterator i1 = this.listIterator();
        LongListIterator i2 = ((LongList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultLongHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract long set(int var1, long var2);

    public abstract long get(int var1);
}

