/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.IntCollection;
import bak.pcj.adapter.CollectionToIntCollectionAdapter;
import bak.pcj.adapter.SetToBooleanSetAdapter;
import bak.pcj.map.AbstractBooleanKeyIntMap;
import bak.pcj.map.BooleanKeyIntMap;
import bak.pcj.map.BooleanKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToBooleanKeyIntMapAdapter
extends AbstractBooleanKeyIntMap
implements BooleanKeyIntMap {
    protected Map map;
    protected Integer lastValue;

    public MapToBooleanKeyIntMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToBooleanKeyIntMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(boolean key) {
        this.lastValue = (Integer)this.map.get(new Boolean(key));
        return this.lastValue != null;
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(new Integer(value));
    }

    public BooleanKeyIntMapIterator entries() {
        return new BooleanKeyIntMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToBooleanKeyIntMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public boolean getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getKey();
            }

            public int getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public int get(boolean key) {
        Integer value = (Integer)this.map.get(new Boolean(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public BooleanSet keySet() {
        return new SetToBooleanSetAdapter(this.map.keySet());
    }

    public int lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(boolean key, int value) {
        Integer oldValue = this.map.put(new Boolean(key), new Integer(value));
        return oldValue == null ? MapDefaults.defaultInt() : oldValue;
    }

    public int remove(boolean key) {
        Integer value = (Integer)this.map.remove(new Boolean(key));
        return value == null ? MapDefaults.defaultInt() : value;
    }

    public int size() {
        return this.map.size();
    }

    public IntCollection values() {
        return new CollectionToIntCollectionAdapter(this.map.values());
    }

    public int tget(boolean key) {
        Integer value = (Integer)this.map.get(new Boolean(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isBooleanKeyIntAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

