/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml311;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SurfaceInterpolationType implements Enumerator
{
    NONE(0, "none", "none"),
    PLANAR(1, "planar", "planar"),
    SPHERICAL(2, "spherical", "spherical"),
    ELLIPTICAL(3, "elliptical", "elliptical"),
    CONIC(4, "conic", "conic"),
    TIN(5, "tin", "tin"),
    PARAMETRIC_CURVE(6, "parametricCurve", "parametricCurve"),
    POLYNOMIAL_SPLINE(7, "polynomialSpline", "polynomialSpline"),
    RATIONAL_SPLINE(8, "rationalSpline", "rationalSpline"),
    TRIANGULATED_SPLINE(9, "triangulatedSpline", "triangulatedSpline");

    public static final int NONE_VALUE = 0;
    public static final int PLANAR_VALUE = 1;
    public static final int SPHERICAL_VALUE = 2;
    public static final int ELLIPTICAL_VALUE = 3;
    public static final int CONIC_VALUE = 4;
    public static final int TIN_VALUE = 5;
    public static final int PARAMETRIC_CURVE_VALUE = 6;
    public static final int POLYNOMIAL_SPLINE_VALUE = 7;
    public static final int RATIONAL_SPLINE_VALUE = 8;
    public static final int TRIANGULATED_SPLINE_VALUE = 9;
    private static final SurfaceInterpolationType[] VALUES_ARRAY;
    public static final List<SurfaceInterpolationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SurfaceInterpolationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SurfaceInterpolationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SurfaceInterpolationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SurfaceInterpolationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SurfaceInterpolationType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return PLANAR;
            }
            case 2: {
                return SPHERICAL;
            }
            case 3: {
                return ELLIPTICAL;
            }
            case 4: {
                return CONIC;
            }
            case 5: {
                return TIN;
            }
            case 6: {
                return PARAMETRIC_CURVE;
            }
            case 7: {
                return POLYNOMIAL_SPLINE;
            }
            case 8: {
                return RATIONAL_SPLINE;
            }
            case 9: {
                return TRIANGULATED_SPLINE;
            }
        }
        return null;
    }

    private SurfaceInterpolationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SurfaceInterpolationType[]{NONE, PLANAR, SPHERICAL, ELLIPTICAL, CONIC, TIN, PARAMETRIC_CURVE, POLYNOMIAL_SPLINE, RATIONAL_SPLINE, TRIANGULATED_SPLINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

