/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fao.geonet.harvester.wfsfeatures.worker.QgisStrategy;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.data.wfs.internal.v1_x.MapServerWFSStrategy;
import org.geotools.data.wfs.internal.v2_0.StrictWFS_2_0_Strategy;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;

public class WFSClientWithStrategyInvestigator
extends WFSClient {
    private String describeFeatureTypeUrl;
    private String strategyId;
    private Logger logger = LogManager.getLogger((String)"geonetwork.harvest.wfs.features");

    public WFSClientWithStrategyInvestigator(URL capabilitiesURL, HTTPClient httpClient, WFSConfig config, String describeFeatureTypeUrl) throws IOException, ServiceException {
        this(capabilitiesURL, httpClient, config, null, describeFeatureTypeUrl);
    }

    public WFSClientWithStrategyInvestigator(URL capabilitiesURL, HTTPClient httpClient, WFSConfig config, WFSGetCapabilities capabilities, String describeFeatureTypeUrl) throws IOException, ServiceException {
        super(capabilitiesURL, httpClient, config, capabilities);
        this.describeFeatureTypeUrl = describeFeatureTypeUrl;
        this.logger.debug("WFS client default strategy is {}", (Object)this.getStrategy());
        WFSStrategy targetNsBasedStrategy = this.determineCorrectStrategy(httpClient);
        if (targetNsBasedStrategy != null) {
            this.logger.debug("Overriding WFS client strategy with GFI target namespace strategy: {}", (Object)targetNsBasedStrategy.getClass().getName());
            this.specification = targetNsBasedStrategy;
            ((WFSStrategy)this.specification).setCapabilities((WFSGetCapabilities)this.capabilities);
        }
    }

    private WFSStrategy determineCorrectStrategy(HTTPClient httpClient) {
        QgisStrategy strategy = null;
        try {
            int readCount;
            this.logger.debug("Determining strategy based on {}", (Object)this.describeFeatureTypeUrl);
            HTTPResponse httpResponse = httpClient.get(new URL(this.describeFeatureTypeUrl));
            InputStream inputStream = httpResponse.getResponseStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((readCount = inputStream.read(buff)) != -1) {
                out.write(buff, 0, readCount);
            }
            String responsePayload = out.toString(StandardCharsets.UTF_8);
            if (responsePayload.contains("targetNamespace=\"http://www.qgis.org/gml\"")) {
                strategy = new QgisStrategy();
                this.strategyId = "qgis";
            } else if (responsePayload.contains("targetNamespace=\"http://mapserver.gis.umn.edu/mapserver\"")) {
                strategy = ((WFSGetCapabilities)this.capabilities).getVersion().equals("2.0.0") ? new StrictWFS_2_0_Strategy() : new MapServerWFSStrategy(((WFSGetCapabilities)this.capabilities).getRawDocument());
                this.strategyId = "mapserver";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strategy;
    }

    public String getStrategyId() {
        return this.strategyId;
    }
}

