/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.util.Utilities;

public class MathTransformProxy
implements MathTransform,
Serializable {
    private static final long serialVersionUID = 8844242705205498128L;
    public final MathTransform transform;

    protected MathTransformProxy(MathTransform transform) {
        this.transform = transform;
    }

    public int getSourceDimensions() {
        return this.transform.getTargetDimensions();
    }

    public int getTargetDimensions() {
        return this.transform.getSourceDimensions();
    }

    public Position transform(Position ptSrc, Position ptDst) throws MismatchedDimensionException, TransformException {
        return this.transform.transform(ptSrc, ptDst);
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public Matrix derivative(Position point) throws TransformException {
        return this.transform.derivative(point);
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        return this.transform.inverse();
    }

    public boolean isIdentity() {
        return this.transform.isIdentity();
    }

    public String toWKT() throws UnsupportedOperationException {
        return this.transform.toWKT();
    }

    public String toString() {
        return this.transform.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            MathTransformProxy that = (MathTransformProxy)object;
            return Utilities.equals((Object)this.transform, (Object)that.transform);
        }
        return false;
    }

    public int hashCode() {
        return this.transform.hashCode() ^ 0xAF1D1110;
    }
}

