/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Map;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.transform.AbstractMathTransform;

class RubberSheetTransform
extends AbstractMathTransform
implements MathTransform2D {
    private TINTriangle previousTriangle = null;
    private Map<TINTriangle, Object> trianglesToKeysMap;

    public RubberSheetTransform(Map<TINTriangle, Object> trianglesToAffineTransform) {
        this.trianglesToKeysMap = trianglesToAffineTransform;
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder buffer = new StringBuilder();
        for (TINTriangle trian : this.trianglesToKeysMap.keySet()) {
            MathTransform mt = (MathTransform)this.trianglesToKeysMap.get(trian);
            buffer.append(trian.toString());
            buffer.append(lineSeparator);
            buffer.append(mt.toString());
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPt, int dstOff, int numPts) throws TransformException {
        for (int i = srcOff; i < numPts; ++i) {
            Position2D pos = new Position2D(srcPts[2 * i], srcPts[2 * i + 1]);
            TINTriangle triangle = this.searchTriangle(pos);
            AffineTransform AT = (AffineTransform)this.trianglesToKeysMap.get(triangle);
            Point2D dst = AT.transform(pos, null);
            dstPt[2 * i] = dst.getX();
            dstPt[2 * i + 1] = dst.getY();
        }
    }

    private TINTriangle searchTriangle(Position p) throws TransformException {
        TINTriangle potentialTriangle = this.previousTriangle;
        if (potentialTriangle != null && potentialTriangle.containsOrIsVertex(p)) {
            return potentialTriangle;
        }
        for (TINTriangle triangle : this.trianglesToKeysMap.keySet()) {
            if (!triangle.containsOrIsVertex(p)) continue;
            this.previousTriangle = triangle;
            return triangle;
        }
        throw new TransformException("Points are outside the scope");
    }

    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }
}

