/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.util.InternationalString;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;

public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    public static final DefaultTemporalDatum JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(117), new Date(-210866760000000L));
    public static final DefaultTemporalDatum MODIFIED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(142), new Date(-3506716800000L));
    public static final DefaultTemporalDatum TRUNCATED_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(227), new Date(-50716800000L));
    public static final DefaultTemporalDatum DUBLIN_JULIAN = new DefaultTemporalDatum(DefaultTemporalDatum.name(51), new Date(-2209032000000L));
    public static final DefaultTemporalDatum UNIX = new DefaultTemporalDatum("UNIX", new Date(0L));
    private final long origin;

    public DefaultTemporalDatum(TemporalDatum datum) {
        super((Datum)datum);
        this.origin = datum.getOrigin().getTime();
    }

    public DefaultTemporalDatum(String name, Date origin) {
        this(Collections.singletonMap("name", name), origin);
    }

    public DefaultTemporalDatum(Map<String, ?> properties, Date origin) {
        super(properties);
        DefaultTemporalDatum.ensureNonNull("origin", origin);
        this.origin = origin.getTime();
    }

    public Date getOrigin() {
        return new Date(this.origin);
    }

    @Override
    public InternationalString getAnchorPoint() {
        return super.getAnchorPoint();
    }

    @Override
    public Date getRealizationEpoch() {
        return super.getRealizationEpoch();
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultTemporalDatum that = (DefaultTemporalDatum)object;
            return this.origin == that.origin;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.origin ^ (int)(this.origin >>> 32);
    }
}

