/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.measure.Unit;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.RangeMeaning;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.AbstractBounds;
import org.geotools.geometry.AbstractPosition;
import org.geotools.geometry.GeneralPosition;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.measure.Units;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;

public class GeneralBounds
extends AbstractBounds
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralBounds(int dimension) {
        this.ordinates = new double[dimension * 2];
        for (int i = 0; i < dimension * 2; ++i) {
            this.ordinates[i] = Double.NaN;
        }
    }

    public GeneralBounds(double min, double max) {
        this.ordinates = new double[]{min, max};
        GeneralBounds.checkCoordinates(this.ordinates);
    }

    public GeneralBounds(double[] minDP, double[] maxDP) throws IllegalArgumentException {
        GeneralBounds.ensureNonNull("minDP", minDP);
        GeneralBounds.ensureNonNull("maxDP", maxDP);
        GeneralBounds.ensureSameDimension(minDP.length, maxDP.length);
        this.ordinates = new double[minDP.length + maxDP.length];
        System.arraycopy(minDP, 0, this.ordinates, 0, minDP.length);
        System.arraycopy(maxDP, 0, this.ordinates, minDP.length, maxDP.length);
        GeneralBounds.checkCoordinates(this.ordinates);
    }

    public GeneralBounds(GeneralPosition minDP, GeneralPosition maxDP) throws MismatchedReferenceSystemException, IllegalArgumentException {
        this(minDP.ordinates, maxDP.ordinates);
        this.crs = GeneralBounds.getCoordinateReferenceSystem(minDP, maxDP);
        AbstractPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length / 2);
    }

    public GeneralBounds(CoordinateReferenceSystem crs) {
        this(crs.getCoordinateSystem().getDimension());
        this.crs = crs;
    }

    public GeneralBounds(CoordinateReferenceSystem crs, double xMin, double yMin, double width, double height) {
        this(crs.getCoordinateSystem().getDimension());
        this.setEnvelope(xMin, yMin, xMin + width, yMin + height);
        this.crs = crs;
    }

    public static GeneralBounds toGeneralEnvelope(Bounds envelope) {
        if (envelope instanceof GeneralBounds) {
            return (GeneralBounds)envelope;
        }
        return new GeneralBounds(envelope);
    }

    public GeneralBounds(Bounds envelope) {
        GeneralBounds.ensureNonNull("envelope", envelope);
        if (envelope instanceof GeneralBounds) {
            GeneralBounds e = (GeneralBounds)envelope;
            this.ordinates = (double[])e.ordinates.clone();
            this.crs = e.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int dimension = envelope.getDimension();
            this.ordinates = new double[2 * dimension];
            for (int i = 0; i < dimension; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + dimension] = envelope.getMaximum(i);
            }
            GeneralBounds.checkCoordinates(this.ordinates);
        }
    }

    public GeneralBounds(GeographicBoundingBox box) {
        GeneralBounds.ensureNonNull("box", box);
        this.ordinates = new double[]{box.getWestBoundLongitude(), box.getSouthBoundLatitude(), box.getEastBoundLongitude(), box.getNorthBoundLatitude()};
        this.crs = DefaultGeographicCRS.WGS84;
    }

    public GeneralBounds(Rectangle2D rect) {
        GeneralBounds.ensureNonNull("rect", rect);
        this.ordinates = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
        GeneralBounds.checkCoordinates(this.ordinates);
    }

    public GeneralBounds(Rectangle2D rect, CoordinateReferenceSystem crs) {
        GeneralBounds.ensureNonNull("rect", rect);
        this.ordinates = new double[]{rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()};
        this.crs = crs;
        GeneralBounds.checkCoordinates(this.ordinates);
    }

    public GeneralBounds(GridEnvelope gridRange, PixelInCell anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws IllegalArgumentException {
        GeneralBounds transformed;
        GeneralBounds.ensureNonNull("gridRange", gridRange);
        GeneralBounds.ensureNonNull("gridToCRS", gridToCRS);
        int dimRange = gridRange.getDimension();
        int dimSource = gridToCRS.getSourceDimensions();
        int dimTarget = gridToCRS.getTargetDimensions();
        GeneralBounds.ensureSameDimension(dimRange, dimSource);
        GeneralBounds.ensureSameDimension(dimRange, dimTarget);
        this.ordinates = new double[dimSource * 2];
        double offset = PixelTranslation.getPixelTranslation(anchor) + 0.5;
        for (int i = 0; i < dimSource; ++i) {
            this.setRange(i, (double)gridRange.getLow(i) - offset, (double)gridRange.getHigh(i) - (offset - 1.0));
        }
        try {
            transformed = CRS.transform(gridToCRS, (Bounds)this);
        }
        catch (TransformException exception) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal transform of type \"{0}\".", Classes.getClass((Object)gridToCRS)), exception);
        }
        assert (transformed.ordinates.length == this.ordinates.length);
        System.arraycopy(transformed.ordinates, 0, this.ordinates, 0, this.ordinates.length);
        this.setCoordinateReferenceSystem(crs);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }

    private static void ensureSameDimension(int dim1, int dim2) throws MismatchedDimensionException {
        if (dim1 != dim2) {
            throw new MismatchedDimensionException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", dim1, dim2));
        }
    }

    private static void checkCoordinates(double[] ordinates) throws IllegalArgumentException {
        if (GeneralBounds.isNilCoordinates(ordinates)) {
            return;
        }
        if (GeneralBounds.isEmptyOrdinates(ordinates)) {
            return;
        }
        int dimension = ordinates.length / 2;
        for (int i = 0; i < dimension; ++i) {
            if (ordinates[i] <= ordinates[dimension + i]) continue;
            throw new IllegalArgumentException(MessageFormat.format("Bad ordinates at dimension {0}.", i));
        }
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        AbstractPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    public boolean normalize(boolean crsDomain) {
        boolean changed = false;
        if (this.crs != null) {
            Bounds domain;
            int dimension = this.ordinates.length / 2;
            CoordinateSystem cs = this.crs.getCoordinateSystem();
            for (int i = 0; i < dimension; ++i) {
                double length;
                int j = i + dimension;
                CoordinateSystemAxis axis = cs.getAxis(i);
                double minimum = axis.getMinimumValue();
                double maximum = axis.getMaximumValue();
                RangeMeaning rm = axis.getRangeMeaning();
                if (RangeMeaning.EXACT.equals((Object)rm)) {
                    if (this.ordinates[i] < minimum) {
                        this.ordinates[i] = minimum;
                        changed = true;
                    }
                    if (!(this.ordinates[j] > maximum)) continue;
                    this.ordinates[j] = maximum;
                    changed = true;
                    continue;
                }
                if (!RangeMeaning.WRAPAROUND.equals((Object)rm) || !((length = maximum - minimum) > 0.0) || !(length < Double.POSITIVE_INFINITY)) continue;
                double offset = Math.floor((this.ordinates[i] - minimum) / length) * length;
                if (offset != 0.0) {
                    int n = i;
                    this.ordinates[n] = this.ordinates[n] - offset;
                    int n2 = j;
                    this.ordinates[n2] = this.ordinates[n2] - offset;
                    changed = true;
                }
                if (!(this.ordinates[j] > maximum)) continue;
                this.ordinates[i] = minimum;
                this.ordinates[j] = maximum;
                changed = true;
            }
            if (crsDomain && (domain = CRS.getEnvelope(this.crs)) != null) {
                CoordinateReferenceSystem domainCRS = domain.getCoordinateReferenceSystem();
                if (domainCRS == null) {
                    this.intersect(domain);
                } else {
                    CoordinateSystem domainCS = domainCRS.getCoordinateSystem();
                    int domainDimension = domainCS.getDimension();
                    for (int i = 0; i < domainDimension; ++i) {
                        double minimum = domain.getMinimum(i);
                        double maximum = domain.getMaximum(i);
                        AxisDirection direction = domainCS.getAxis(i).getDirection();
                        for (int j = 0; j < dimension; ++j) {
                            if (!direction.equals((Object)cs.getAxis(j).getDirection())) continue;
                            int k = j + dimension;
                            if (this.ordinates[j] < minimum) {
                                this.ordinates[j] = minimum;
                            }
                            if (!(this.ordinates[k] > maximum)) continue;
                            this.ordinates[k] = maximum;
                        }
                    }
                }
            }
        }
        return changed;
    }

    public final int getDimension() {
        return this.ordinates.length / 2;
    }

    @Override
    public Position getLowerCorner() {
        int dim = this.ordinates.length / 2;
        GeneralPosition position = new GeneralPosition(dim);
        System.arraycopy(this.ordinates, 0, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    @Override
    public Position getUpperCorner() {
        int dim = this.ordinates.length / 2;
        GeneralPosition position = new GeneralPosition(dim);
        System.arraycopy(this.ordinates, dim, position.ordinates, 0, dim);
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    public Position getMedian() {
        GeneralPosition position = new GeneralPosition(this.ordinates.length / 2);
        int i = position.ordinates.length;
        while (--i >= 0) {
            position.ordinates[i] = this.getMedian(i);
        }
        position.setCoordinateReferenceSystem(this.crs);
        return position;
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int dimension) {
        return new IndexOutOfBoundsException(MessageFormat.format("Index {0} is out of bounds.", dimension));
    }

    public final double getMinimum(int dimension) throws IndexOutOfBoundsException {
        if (dimension < this.ordinates.length / 2) {
            return this.ordinates[dimension];
        }
        throw GeneralBounds.indexOutOfBounds(dimension);
    }

    public final double getMaximum(int dimension) throws IndexOutOfBoundsException {
        if (dimension >= 0) {
            return this.ordinates[dimension + this.ordinates.length / 2];
        }
        throw GeneralBounds.indexOutOfBounds(dimension);
    }

    public final double getMedian(int dimension) throws IndexOutOfBoundsException {
        return 0.5 * (this.ordinates[dimension] + this.ordinates[dimension + this.ordinates.length / 2]);
    }

    public final double getSpan(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension + this.ordinates.length / 2] - this.ordinates[dimension];
    }

    public double getSpan(int dimension, Unit<?> unit) throws IndexOutOfBoundsException {
        Unit source;
        double value = this.getSpan(dimension);
        if (this.crs != null && (source = this.crs.getCoordinateSystem().getAxis(dimension).getUnit()) != null) {
            value = Units.getConverterToAny((Unit)source, unit).convert(value);
        }
        return value;
    }

    public void setRange(int dimension, double minimum, double maximum) throws IndexOutOfBoundsException {
        if (minimum > maximum) {
            minimum = maximum = 0.5 * (minimum + maximum);
        }
        if (dimension < 0) {
            throw GeneralBounds.indexOutOfBounds(dimension);
        }
        this.ordinates[dimension + this.ordinates.length / 2] = maximum;
        this.ordinates[dimension] = minimum;
    }

    public void setEnvelope(double ... ordinates) {
        if ((ordinates.length & 1) != 0) {
            throw new IllegalArgumentException(MessageFormat.format("Bad array length: {0}. An even array length was expected.", ordinates.length));
        }
        int dimension = ordinates.length >>> 1;
        int check = this.ordinates.length >>> 1;
        if (dimension != check) {
            throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", "ordinates", dimension, check));
        }
        GeneralBounds.checkCoordinates(ordinates);
        System.arraycopy(ordinates, 0, this.ordinates, 0, ordinates.length);
    }

    public void setEnvelope(GeneralBounds envelope) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("envelope", envelope);
        AbstractPosition.ensureDimensionMatch("envelope", envelope.getDimension(), this.getDimension());
        System.arraycopy(envelope.ordinates, 0, this.ordinates, 0, this.ordinates.length);
        if (envelope.crs != null) {
            this.crs = envelope.crs;
            assert (this.crs.getCoordinateSystem().getDimension() == this.getDimension()) : this.crs;
            assert (!envelope.getClass().equals(this.getClass()) || this.equals(envelope)) : envelope;
        }
    }

    public void setToInfinite() {
        int mid = this.ordinates.length / 2;
        Arrays.fill(this.ordinates, 0, mid, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.ordinates, mid, this.ordinates.length, Double.POSITIVE_INFINITY);
        assert (this.isInfinite()) : this;
    }

    public boolean isInfinite() {
        for (double ordinate : this.ordinates) {
            if (!Double.isInfinite(ordinate)) continue;
            return true;
        }
        return false;
    }

    public void setToNull() {
        Arrays.fill(this.ordinates, Double.NaN);
        assert (this.isNull()) : this;
    }

    public boolean isNull() {
        if (!GeneralBounds.isNilCoordinates(this.ordinates)) {
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    private static boolean isNilCoordinates(double[] ordinates) throws IllegalArgumentException {
        for (double ordinate : ordinates) {
            if (Double.isNaN(ordinate)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (GeneralBounds.isEmptyOrdinates(this.ordinates)) {
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    private static boolean isEmptyOrdinates(double[] ordinates) {
        int dimension = ordinates.length / 2;
        if (dimension == 0) {
            return true;
        }
        for (int i = 0; i < dimension; ++i) {
            if (ordinates[i] < ordinates[i + dimension]) continue;
            return true;
        }
        return false;
    }

    private static boolean equalsIgnoreMetadata(CoordinateReferenceSystem crs1, CoordinateReferenceSystem crs2) {
        boolean equalCrs;
        boolean bl = equalCrs = crs1 == null || crs2 == null || CRS.equalsIgnoreMetadata(crs1, crs2);
        if (!equalCrs) {
            try {
                equalCrs = !CRS.isTransformationRequired(crs1, crs2);
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        return equalCrs;
    }

    public void add(double x, double y) throws MismatchedDimensionException {
        this.add(new Position2D(this.getCoordinateReferenceSystem(), x, y));
    }

    public void add(Position position) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("position", position);
        int dim = this.ordinates.length / 2;
        AbstractPosition.ensureDimensionMatch("position", position.getDimension(), dim);
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem())) : position;
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (value < this.ordinates[i] || Double.isNaN(this.ordinates[i])) {
                this.ordinates[i] = value;
            }
            if (!(value > this.ordinates[i + dim]) && !Double.isNaN(this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = value;
        }
        assert (this.isEmpty() || this.contains(position));
    }

    public void add(Bounds envelope) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < dim; ++i) {
            double min = envelope.getMinimum(i);
            double max = envelope.getMaximum(i);
            if (min < this.ordinates[i]) {
                this.ordinates[i] = min;
            }
            if (!(max > this.ordinates[i + dim])) continue;
            this.ordinates[i + dim] = max;
        }
        assert (this.isEmpty() || this.contains(envelope, true));
    }

    public boolean contains(Position position) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("position", position);
        int dim = this.ordinates.length / 2;
        AbstractPosition.ensureDimensionMatch("point", position.getDimension(), dim);
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, position.getCoordinateReferenceSystem())) : position;
        for (int i = 0; i < dim; ++i) {
            double value = position.getOrdinate(i);
            if (!(value >= this.ordinates[i])) {
                return false;
            }
            if (value <= this.ordinates[i + dim]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Bounds envelope, boolean edgesInclusive) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < dim; ++i) {
            double inner = envelope.getMinimum(i);
            double outer = this.ordinates[i];
            if (!(!edgesInclusive ? inner > outer : inner >= outer)) {
                return false;
            }
            inner = envelope.getMaximum(i);
            outer = this.ordinates[i + dim];
            if (!edgesInclusive ? inner < outer : inner <= outer) continue;
            return false;
        }
        assert (this.intersects(envelope, edgesInclusive));
        return true;
    }

    public boolean intersects(Bounds envelope, boolean edgesInclusive) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < dim; ++i) {
            double inner = envelope.getMaximum(i);
            double outer = this.ordinates[i];
            if (!(!edgesInclusive ? inner > outer : inner >= outer)) {
                return false;
            }
            inner = envelope.getMinimum(i);
            outer = this.ordinates[i + dim];
            if (!edgesInclusive ? inner < outer : inner <= outer) continue;
            return false;
        }
        return true;
    }

    public void intersect(Bounds envelope) throws MismatchedDimensionException {
        GeneralBounds.ensureNonNull("envelope", envelope);
        int dim = this.ordinates.length / 2;
        AbstractPosition.ensureDimensionMatch("envelope", envelope.getDimension(), dim);
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < dim; ++i) {
            double max;
            double min = Math.max(this.ordinates[i], envelope.getMinimum(i));
            if (min > (max = Math.min(this.ordinates[i + dim], envelope.getMaximum(i)))) {
                min = max = 0.5 * (min + max);
            }
            this.ordinates[i] = min;
            this.ordinates[i + dim] = max;
        }
    }

    public GeneralBounds getSubEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.ordinates.length / 2;
        int newDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "lower", lower));
        }
        if (newDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "upper", upper));
        }
        GeneralBounds envelope = new GeneralBounds(newDim);
        System.arraycopy(this.ordinates, lower, envelope.ordinates, 0, newDim);
        System.arraycopy(this.ordinates, lower + curDim, envelope.ordinates, newDim, newDim);
        return envelope;
    }

    public GeneralBounds getReducedEnvelope(int lower, int upper) throws IndexOutOfBoundsException {
        int curDim = this.ordinates.length / 2;
        int rmvDim = upper - lower;
        if (lower < 0 || lower > curDim) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "lower", lower));
        }
        if (rmvDim < 0 || upper > curDim) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "upper", upper));
        }
        GeneralBounds envelope = new GeneralBounds(curDim - rmvDim);
        System.arraycopy(this.ordinates, 0, envelope.ordinates, 0, lower);
        System.arraycopy(this.ordinates, lower, envelope.ordinates, upper, curDim - upper);
        return envelope;
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        if (this.ordinates.length == 4) {
            return XRectangle2D.createFromExtremums(this.ordinates[0], this.ordinates[1], this.ordinates[2], this.ordinates[3]);
        }
        throw new IllegalStateException(MessageFormat.format("Can't wrap a {0} dimensional object into a 2 dimensional one.", this.getDimension()));
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralBounds that = (GeneralBounds)object;
            return Arrays.equals(this.ordinates, that.ordinates) && Utilities.equals((Object)this.crs, (Object)that.crs);
        }
        return false;
    }

    public boolean equals(Bounds envelope, double eps, boolean epsIsRelative) {
        GeneralBounds.ensureNonNull("envelope", envelope);
        int dimension = this.getDimension();
        if (envelope.getDimension() != dimension) {
            return false;
        }
        assert (GeneralBounds.equalsIgnoreMetadata(this.crs, envelope.getCoordinateReferenceSystem())) : envelope;
        for (int i = 0; i < dimension; ++i) {
            double epsilon;
            epsilon = epsIsRelative ? ((epsilon = Math.max(this.getSpan(i), envelope.getSpan(i))) > 0.0 && epsilon < Double.POSITIVE_INFINITY ? epsilon * eps : eps) : eps;
            if (Math.abs(this.getMinimum(i) - envelope.getMinimum(i)) <= epsilon && Math.abs(this.getMaximum(i) - envelope.getMaximum(i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public GeneralBounds clone() {
        try {
            GeneralBounds e = (GeneralBounds)super.clone();
            e.ordinates = (double[])e.ordinates.clone();
            return e;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

