/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Parameters;
import org.apache.jena.shacl.vocabulary.SHACL;

public class TargetExtensions {
    MultiValuedMap<Node, SparqlComponent> paramPathToComponents = MultiMapUtils.newListValuedHashMap();
    Set<Parameter> parameters = new HashSet<Parameter>();

    public static TargetExtensions parseSPARQLTargetType(Graph shapesGraph) {
        TargetExtensions x = new TargetExtensions();
        G.allNodesOfTypeRDFS((Graph)shapesGraph, (Node)SHACL.SPARQLTargetType).forEach(sttNode -> {
            SparqlComponent c = TargetExtensions.sparqlTargetType(shapesGraph, sttNode);
            if (c != null) {
                for (Parameter p : c.getParams()) {
                    x.paramPathToComponents.put((Object)p.getParameterPath(), (Object)c);
                    x.parameters.add(p);
                }
            }
        });
        return x;
    }

    public static SparqlComponent sparqlTargetType(Graph shapesGraph, Node sparqlTargetTypeNode) {
        List<Parameter> params = Parameters.parseParameters(shapesGraph, sparqlTargetTypeNode);
        String sparqlString = ShLib.extractSPARQLQueryString(shapesGraph, sparqlTargetTypeNode);
        return SparqlComponent.targetType(sparqlString, params);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }
}

