/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Timer;
import java.util.TimerTask;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.rmi.FactoryInterface;
import org.openrdf.sesame.server.rmi.ServicesInterfaceImpl;
import org.openrdf.util.rmirouting.ChannelIfaceImpl;
import org.openrdf.util.rmirouting.KeepAliveWhenUnreferenced;
import org.openrdf.util.rmirouting.RoutingAction;

public class FactoryInterfaceImpl
implements FactoryInterface,
KeepAliveWhenUnreferenced {
    private static String sessionPrefix = String.valueOf(System.currentTimeMillis());
    private static int sessionCounter = 1;

    public static void bind() {
        FactoryInterfaceImpl.bind(new Integer(1099));
    }

    public static void bind(Integer port) {
        boolean bNotError = true;
        try {
            Registry reg = LocateRegistry.getRegistry(port);
            if (reg == null) {
                reg = LocateRegistry.createRegistry(port);
            }
            FactoryInterfaceImpl theFactory = new FactoryInterfaceImpl();
            ChannelIfaceImpl.setPrologAction((RoutingAction)new RoutingAction(){

                public void doRoutingAction(Object cookie) {
                    ServicesInterfaceImpl.getContext(cookie);
                }
            });
            Remote fi = ChannelIfaceImpl.createStub((Object)theFactory);
            try {
                reg.bind("FactoryInterface", fi);
            }
            catch (AlreadyBoundException e) {
                reg.rebind("FactoryInterface", fi);
            }
            catch (ConnectException e) {
                reg = LocateRegistry.createRegistry(port);
                try {
                    reg.bind("FactoryInterface", fi);
                }
                catch (AlreadyBoundException e1) {
                    reg.rebind("FactoryInterface", fi);
                }
            }
        }
        catch (RemoteException re) {
            System.out.println("RMI:FactoryInterfaceImpl:RemoteException:" + re.getMessage());
            bNotError = false;
        }
        if (bNotError) {
            System.out.println("FactoryInteface registered on port " + port);
        } else {
            System.out.println("FactoryInteface is not registered");
        }
    }

    public static void unbind() {
        FactoryInterfaceImpl.unbind(new Integer(1099));
    }

    public static void unbind(Integer port) {
        try {
            Registry reg = LocateRegistry.getRegistry(port);
            if (reg != null) {
                reg.unbind("FactoryInterface");
                System.out.println("FactoryInteface unregistered from port " + port);
            }
        }
        catch (RemoteException re) {
            System.out.println("FactoryInteface failed:" + re.getMessage());
        }
        catch (NotBoundException re) {
            System.out.println("FactoryInteface failed:" + re.getMessage());
        }
    }

    private String nextSessionID() {
        return sessionPrefix + String.valueOf(sessionCounter++);
    }

    public SesameService getService() {
        SessionContext.setContext(null);
        String cookieTouse = this.nextSessionID();
        ChannelIfaceImpl.setCurrentCookie((Object)cookieTouse);
        return new ServicesInterfaceImpl(cookieTouse);
    }

    public void stopService() {
        SesameServer.clear();
        new Timer().schedule(new TimerTask(){

            public void run() {
                System.exit(0);
            }
        }, 3000L);
    }

    public static void main(String[] options) {
        FactoryInterfaceImpl.bind();
        FactoryInterfaceImpl.unbind();
    }
}

