/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf.datastore;

import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.DataFile;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.HashFile;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.IDFile;
import org.openrdf.util.ByteArrayUtil;

public class DataStore {
    private static final int COUNT_IDX = 0;
    private static final int ID_IDX = 4;
    private static final int DATA_IDX = 8;
    private DataFile _dataFile;
    private IDFile _idFile;
    private HashFile _hashFile;
    private CRC32 _crc32 = new CRC32();

    public DataStore(File dataDir, String filePrefix) throws IOException {
        this._dataFile = new DataFile(new File(dataDir, filePrefix + ".dat"));
        this._idFile = new IDFile(new File(dataDir, filePrefix + ".id"));
        this._hashFile = new HashFile(new File(dataDir, filePrefix + ".hash"));
    }

    public byte[] getData(int id) throws IOException {
        return this.getData(id, false);
    }

    public byte[] getData(int id, boolean dirtyReads) throws IOException {
        long offset = this._idFile.getOffset(id, dirtyReads);
        if (offset != 0L) {
            byte[] combinedData = this._dataFile.getData(offset, dirtyReads);
            return DataStore._getDataFromCombinedArray(combinedData);
        }
        return null;
    }

    public int getID(byte[] queryData) throws IOException {
        return this.getID(queryData, false);
    }

    public int getID(byte[] queryData, boolean dirtyReads) throws IOException {
        return this._getID(queryData, this._getHash(queryData), dirtyReads);
    }

    private int _getID(byte[] queryData, int hash, boolean dirtyReads) throws IOException {
        HashFile.OffsetIterator iter = this._hashFile.getOffsetIterator(hash, dirtyReads);
        long offset = iter.next();
        while (offset >= 0L) {
            byte[] combinedData = this._dataFile.getData(offset, dirtyReads);
            if (queryData.length + 8 == combinedData.length && ByteArrayUtil.regionMatches((byte[])queryData, (byte[])combinedData, (int)8)) {
                return DataStore._getIdFromCombinedArray(combinedData);
            }
            offset = iter.next();
        }
        return 0;
    }

    public int getMaxID() throws IOException {
        return this._idFile.getMaxID();
    }

    public void startTransaction() throws IOException {
        this._dataFile.startTransaction(false);
        this._idFile.startTransaction(false);
        this._hashFile.startTransaction(false);
    }

    public void commitTransaction() throws IOException {
        this._hashFile.commitTransaction();
        this._idFile.commitTransaction();
        this._dataFile.commitTransaction();
    }

    public void rollbackTransaction() throws IOException {
        this._hashFile.rollbackTransaction();
        this._idFile.rollbackTransaction();
        this._dataFile.rollbackTransaction();
    }

    public int storeData(byte[] data) throws IOException {
        int hash = this._getHash(data);
        int id = this._getID(data, hash, true);
        if (id == 0) {
            id = this._idFile.getNewID();
            byte[] combinedData = DataStore._createCombinedArray(1, id, data);
            long offset = this._dataFile.storeData(combinedData);
            this._hashFile.storeOffset(hash, offset);
            this._idFile.storeOffset(id, offset);
        }
        return id;
    }

    public void clear() throws IOException {
        this._hashFile.clear();
        this._idFile.clear();
        this._dataFile.clear();
    }

    public void close() throws IOException {
        this._hashFile.close();
        this._idFile.close();
        this._dataFile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getHash(byte[] data) {
        CRC32 cRC32 = this._crc32;
        synchronized (cRC32) {
            this._crc32.update(data);
            int crc = (int)this._crc32.getValue();
            this._crc32.reset();
            return crc;
        }
    }

    private static byte[] _createCombinedArray(int count, int id, byte[] data) {
        byte[] result = new byte[8 + data.length];
        ByteArrayUtil.putInt((int)count, (byte[])result, (int)0);
        ByteArrayUtil.putInt((int)id, (byte[])result, (int)4);
        ByteArrayUtil.put((byte[])data, (byte[])result, (int)8);
        return result;
    }

    private static int _getCountFromCombinedArray(byte[] data) {
        return ByteArrayUtil.getInt((byte[])data, (int)0);
    }

    private static int _getIdFromCombinedArray(byte[] data) {
        return ByteArrayUtil.getInt((byte[])data, (int)4);
    }

    private static byte[] _getDataFromCombinedArray(byte[] data) {
        return ByteArrayUtil.get((byte[])data, (int)8);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            DataStore._printContents(args);
        } else {
            DataStore._test(args);
        }
    }

    private static void _test(String[] args) throws Exception {
        int i;
        System.out.println("Running DataStore test...");
        File dataDir = new File(args[0]);
        DataStore dataStore = new DataStore(dataDir, "strings");
        System.out.println("Creating strings...");
        int stringCount = Integer.parseInt(args[1]);
        String[] strings = new String[stringCount];
        for (int i2 = 0; i2 < stringCount; ++i2) {
            strings[i2] = String.valueOf(i2 + 1);
        }
        System.out.println("Starting transaction...");
        long startTime = System.currentTimeMillis();
        dataStore.startTransaction();
        for (int i3 = 0; i3 < strings.length; ++i3) {
            String s = strings[i3];
            byte[] sBytes = s.getBytes();
            int sID = dataStore.getID(sBytes, true);
            if (sID != 0) continue;
            sID = dataStore.storeData(sBytes);
        }
        System.out.println("Commiting transaction...");
        dataStore.commitTransaction();
        long endTime = System.currentTimeMillis();
        System.out.println("Transaction finished in " + (endTime - startTime) + " ms");
        System.out.println("Fetching IDs for all strings...");
        startTime = System.currentTimeMillis();
        for (i = 0; i < strings.length; ++i) {
            String s = strings[i];
            int sID = dataStore.getID(s.getBytes());
            if (sID == i + 1) continue;
            System.out.println("Unexpected ID for string \"" + s + "\": " + sID);
        }
        endTime = System.currentTimeMillis();
        System.out.println("All IDs fetched in " + (endTime - startTime) + " ms");
        System.out.println("Fetching data for all IDs...");
        startTime = System.currentTimeMillis();
        for (i = 0; i < strings.length; ++i) {
            String s = new String(dataStore.getData(i + 1));
            if (s.equals(strings[i])) continue;
            System.out.println("Unexpected string for ID " + (i + 1) + ": \"" + s + "\"");
        }
        endTime = System.currentTimeMillis();
        System.out.println("All data fetched in " + (endTime - startTime) + " ms");
        System.out.println("Closing DataStore...");
        dataStore.close();
        System.out.println("Done.");
    }

    private static void _printContents(String[] args) throws Exception {
        System.out.println("Dumping DataStore contents...");
        File dataDir = new File(args[0]);
        DataStore dataStore = new DataStore(dataDir, args[1]);
        DataFile.DataIterator iter = dataStore._dataFile.iterator();
        while (iter.hasNext()) {
            byte[] combinedData = iter.next();
            int count = DataStore._getCountFromCombinedArray(combinedData);
            int id = DataStore._getIdFromCombinedArray(combinedData);
            byte[] data = DataStore._getDataFromCombinedArray(combinedData);
            System.out.println("id=" + id + " count=" + count + ": " + ByteArrayUtil.toHexString((byte[])data));
        }
    }
}

