/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.memory.MemStatementIterator;
import org.openrdf.sesame.sailimpl.memory.RdfSource;
import org.openrdf.sesame.sailimpl.memory.StatementList;
import org.openrdf.sesame.sailimpl.memory.ValueNode;

public class LiteralNode
extends LiteralImpl
implements ValueNode {
    protected transient RdfSource _source;
    protected transient StatementList _objectStatements = new StatementList(1);

    LiteralNode(RdfSource source, String label) {
        super(label);
        this._source = source;
    }

    public LiteralNode(RdfSource source, String label, String lang) {
        super(label, lang);
        this._source = source;
    }

    public LiteralNode(RdfSource source, String label, URI datatype) {
        super(label, datatype);
        this._source = source;
    }

    public StatementList getObjectStatementList() {
        return this._objectStatements;
    }

    public StatementIterator getObjectStatements() {
        return new MemStatementIterator(this._objectStatements);
    }

    public int getObjectStatementCount() {
        return this._objectStatements.size();
    }

    public void addObjectStatement(Statement st) {
        this._objectStatements.add(st);
    }

    public void removeObjectStatement(Statement st) {
        this._objectStatements.remove(st);
    }

    public RdfSource getRdfSource() {
        return this._source;
    }
}

