/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.UserTable;
import org.openrdf.sesame.config.ui.util.GridBagUtil;
import org.openrdf.sesame.config.ui.util.Util;

public class UserTab
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected SystemConfig _config;
    protected UserTable _table;
    protected JButton _addButton;
    protected JButton _removeButton;

    public UserTab(SystemConfig config) {
        this._config = config;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        URL url = this.getClass().getResource("icons/user.png");
        JLabel icon = new JLabel(new ImageIcon(url));
        GridBagUtil.constrain(this, icon, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 4, 4);
        JTextArea explanation = Util.createReadOnlyTextArea("Use the list below to add users to, or remove users from Sesame,\nand to change their passwords and other settings.", this.getBackground());
        GridBagUtil.constrain(this, explanation, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 4, 4, 0);
        JTextArea title = Util.createTitle("Users for Sesame:", this.getBackground());
        GridBagUtil.constrain(this, title, 0, 1, 2, 1, 0, 17, 0.0, 0.0, 4, 0, 4, 0);
        GridBagUtil.constrain(this, this._createList(), 0, 2, 2, 1, 1, 10, 1.0, 1.0, 4, 0, 4, 0);
        GridBagUtil.constrain(this, this._createButtons(), 0, 3, 2, 1, 0, 13, 1.0, 0.0, 4, 0, 0, 0);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._enableDisableComponents();
    }

    protected JScrollPane _createList() {
        JScrollPane list = new JScrollPane();
        this._table = new UserTable(this._config);
        JViewport viewport = list.getViewport();
        viewport.add(this._table);
        viewport.setBackground(Color.white);
        viewport.setPreferredSize(new Dimension(450, 200));
        list.setVerticalScrollBarPolicy(22);
        return list;
    }

    protected JPanel _createButtons() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));
        URL url = this.getClass().getResource("icons/add-user.png");
        this._addButton = new JButton(new ImageIcon(url));
        this._addButton.setToolTipText("Add new user to list");
        buttonPanel.add(this._addButton);
        this._addButton.addActionListener(this);
        url = this.getClass().getResource("icons/remove-user.png");
        this._removeButton = new JButton(new ImageIcon(url));
        this._removeButton.setToolTipText("Remove user from list");
        buttonPanel.add(this._removeButton);
        this._removeButton.addActionListener(this);
        return buttonPanel;
    }

    public void actionPerformed(ActionEvent event) {
        if (this._table.stopCellEditing()) {
            Object source = event.getSource();
            if (source == this._addButton) {
                this._table.addNewRow();
            } else if (source == this._removeButton) {
                this._table.removeRow();
            }
        } else {
            this._table.requestFocus();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this._enableDisableComponents();
    }

    protected void _enableDisableComponents() {
        int selectedUserIdx = this._table.getSelectedRow();
        this._removeButton.setEnabled(selectedUserIdx != -1);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this._table.isEditing()) {
            this._table.requestFocus();
        }
    }
}

