/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.admin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.util.xml.SimpleSAXAdapter;
import org.openrdf.util.xml.SimpleSAXListener;
import org.openrdf.util.xml.SimpleSAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlAdminMsgReader {
    private SimpleSAXParser _simpleSAXParser;
    private ValueFactory _valueFactory;

    public XmlAdminMsgReader(XMLReader xmlReader) {
        this(xmlReader, (ValueFactory)new ValueFactoryImpl());
    }

    public XmlAdminMsgReader(XMLReader xmlReader, ValueFactory valueFactory) {
        this._simpleSAXParser = new SimpleSAXParser(xmlReader);
        this._valueFactory = valueFactory;
    }

    public synchronized void read(InputStream in, AdminListener listener) throws SAXException, IOException {
        this._simpleSAXParser.setListener((SimpleSAXListener)new XmlAdminMsgParser(listener));
        this._simpleSAXParser.parse(in);
    }

    class XmlAdminMsgParser
    extends SimpleSAXAdapter {
        private AdminListener _listener;
        private String _currentMsg;
        private int _currentColumnNo = -1;
        private int _currentLineNo = -1;
        private ArrayList _values = new ArrayList(3);
        private Statement _currentStatement;

        public XmlAdminMsgParser(AdminListener listener) {
            this._listener = listener;
        }

        public void startTag(String tagName, Map atts, String text) {
            if (tagName.equals("transaction")) {
                this._listener.transactionStart();
            } else if (tagName.equals("msg")) {
                this._currentMsg = text;
            } else if (tagName.equals("line")) {
                try {
                    this._currentLineNo = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    this._currentLineNo = -1;
                }
            } else if (tagName.equals("column")) {
                try {
                    this._currentColumnNo = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    this._currentColumnNo = -1;
                }
            } else if (tagName.equals("uri")) {
                this._values.add(XmlAdminMsgReader.this._valueFactory.createURI(text));
            } else if (tagName.equals("bNode")) {
                this._values.add(XmlAdminMsgReader.this._valueFactory.createBNode());
            } else if (tagName.equals("literal")) {
                String xmlLang = (String)atts.get("xml:lang");
                String datatype = (String)atts.get("datatype");
                Literal literal = null;
                if (datatype != null) {
                    URI dtURI = XmlAdminMsgReader.this._valueFactory.createURI(datatype);
                    literal = XmlAdminMsgReader.this._valueFactory.createLiteral(text, dtURI);
                } else {
                    literal = xmlLang != null ? XmlAdminMsgReader.this._valueFactory.createLiteral(text, xmlLang) : XmlAdminMsgReader.this._valueFactory.createLiteral(text);
                }
                this._values.add(literal);
            }
        }

        public void endTag(String tagName) {
            if (tagName.equals("transaction")) {
                this._listener.transactionEnd();
            } else if (tagName.equals("statement")) {
                if (this._values.size() >= 3) {
                    try {
                        Resource subject = (Resource)this._values.get(0);
                        URI predicate = (URI)this._values.get(1);
                        Value object = (Value)this._values.get(2);
                        this._currentStatement = XmlAdminMsgReader.this._valueFactory.createStatement(subject, predicate, object);
                    }
                    catch (ClassCastException classCastException) {}
                }
            } else if (tagName.equals("status")) {
                this._listener.status(this._currentMsg, this._currentLineNo, this._currentColumnNo);
            } else if (tagName.equals("notification")) {
                this._listener.notification(this._currentMsg, this._currentLineNo, this._currentColumnNo, this._currentStatement);
            } else if (tagName.equals("warning")) {
                this._listener.warning(this._currentMsg, this._currentLineNo, this._currentColumnNo, this._currentStatement);
            } else if (tagName.equals("error")) {
                this._listener.error(this._currentMsg, this._currentLineNo, this._currentColumnNo, this._currentStatement);
            }
            if (tagName.equals("status") || tagName.equals("notification") || tagName.equals("warning") || tagName.equals("error")) {
                this._currentMsg = null;
                this._currentLineNo = -1;
                this._currentColumnNo = -1;
                this._values.clear();
                this._currentStatement = null;
            }
        }
    }
}

