/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ho.util.Logger;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.State;
import org.ho.yaml.Utilities;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.wrapper.MapWrapper;
import org.ho.yaml.wrapper.ObjectWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapState
extends State {
    Object key;

    MapState(Map<String, ObjectWrapper> map, Stack<State> stack, YamlDecoder yamlDecoder, Logger logger) {
        super(map, stack, yamlDecoder, logger);
    }

    protected MapWrapper getMap() {
        return (MapWrapper)this.getWrapper();
    }

    @Override
    public void nextOnContent(String string, String string2) {
        if (this.key == null) {
            this.key = "value".equals(string) ? Utilities.decodeSimpleType(string2) : string2;
        } else {
            ObjectWrapper objectWrapper = null;
            if ("alias".equals(string)) {
                String string3 = string2.substring(1);
                if (this.aliasMap.containsKey(string3)) {
                    objectWrapper = (ObjectWrapper)this.aliasMap.get(string3);
                    final Object object = this.key;
                    objectWrapper.addCreateHandler(new ObjectWrapper.CreateListener(){

                        public void created(Object object2) {
                            MapState.this.getMap().put(object, object2);
                        }
                    });
                }
            } else {
                objectWrapper = this.decoder.getConfig().getWrapperSetContent(this.expectedType(string), string2);
                this.getMap().put(this.key, objectWrapper.getObject());
                if (this.getAnchorname() != null) {
                    this.markAnchor(objectWrapper, this.getAnchorname());
                }
            }
            this.clear();
            this.key = null;
        }
    }

    @Override
    public void nextOnEvent(int n) {
        switch (n) {
            case 58: {
                break;
            }
            case 125: {
                this.stack.pop();
                ((State)this.stack.peek()).childCallback(this.wrapper);
                break;
            }
            default: {
                super.nextOnEvent(n);
            }
        }
    }

    @Override
    public void childCallback(ObjectWrapper objectWrapper) {
        this.getMap().put(this.key, objectWrapper.getObject());
        this.clear();
        this.key = null;
    }

    @Override
    protected String expectedType() {
        if (this.getClassname() != null) {
            return this.getClassname();
        }
        Class clazz = this.getMap().getExpectedType(this.key);
        if (clazz == null) {
            return null;
        }
        String string = ReflectionUtil.className(clazz);
        if (List.class.getName().equals(string)) {
            return ArrayList.class.getName();
        }
        if (Map.class.getName().equals(string)) {
            return HashMap.class.getName();
        }
        return string;
    }
}

