/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class SwingWorker
extends ThreadFactoryUser
implements Runnable {
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable command) {
            Thread t = new Thread(command);
            t.setPriority(2);
            return t;
        }
    };
    private final FutureResult result = new FutureResult();
    private final long timeout;
    private Thread thread;

    public SwingWorker() {
        this(FACTORY, 0L);
    }

    public SwingWorker(long msecs) {
        this(FACTORY, msecs);
    }

    protected SwingWorker(ThreadFactory factory, long msecs) {
        this.setThreadFactory(factory);
        if (msecs < 0L) {
            throw new IllegalArgumentException("timeout=" + msecs);
        }
        this.timeout = msecs;
    }

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        return this.result.get();
    }

    public InvocationTargetException getException() {
        return this.result.getException();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception exception) {}
        }
        this.result.setException(new InterruptedException());
    }

    public boolean isReady() {
        return this.result.isReady();
    }

    public void run() {
        Callable function = new Callable(){

            public Object call() throws Exception {
                return SwingWorker.this.construct();
            }
        };
        Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        long msecs = this.getTimeout();
        if (msecs != 0L) {
            TimedCallable tc = new TimedCallable(function, msecs);
            tc.setThreadFactory(this.getThreadFactory());
            function = tc;
        }
        this.result.setter(function).run();
        SwingUtilities.invokeLater(doFinished);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = this.getThreadFactory().newThread(this);
        }
        this.thread.start();
    }

    public Object timedGet(long msecs) throws TimeoutException, InterruptedException, InvocationTargetException {
        return this.result.timedGet(msecs);
    }
}

