/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthority;
import org.springframework.util.StringUtils;

public class NestedLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(NestedLdapAuthoritiesPopulator.class);
    private Set<String> attributeNames;
    private int maxSearchDepth = 10;

    public NestedLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        super(contextSource, groupSearchBase);
    }

    @Override
    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        if (this.getGroupSearchBase() == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        this.performNestedSearch(userDn, username, authorities, this.getMaxSearchDepth());
        return authorities;
    }

    private void performNestedSearch(String userDn, String username, Set<GrantedAuthority> authorities, int depth) {
        if (depth == 0) {
            logger.debug((Object)LogMessage.of(() -> "Aborted search since max depth reached, for roles for user '" + username + " with DN = " + userDn + " and filter " + this.getGroupSearchFilter() + " in search base '" + this.getGroupSearchBase() + "'"));
            return;
        }
        logger.trace((Object)LogMessage.of(() -> "Searching for roles for user " + username + " with DN " + userDn + " and filter " + this.getGroupSearchFilter() + " in search base " + this.getGroupSearchBase()));
        if (this.getAttributeNames() == null) {
            this.setAttributeNames(new HashSet<String>());
        }
        if (StringUtils.hasText((String)this.getGroupRoleAttribute()) && !this.getAttributeNames().contains(this.getGroupRoleAttribute())) {
            this.getAttributeNames().add(this.getGroupRoleAttribute());
        }
        Set<Map<String, List<String>>> userRoles = this.getLdapTemplate().searchForMultipleAttributeValues(this.getGroupSearchBase(), this.getGroupSearchFilter(), new String[]{userDn, username}, this.getAttributeNames().toArray(new String[0]));
        logger.debug((Object)LogMessage.format((String)"Found roles from search %s", userRoles));
        for (Map<String, List<String>> record : userRoles) {
            String roleName;
            boolean circular = false;
            String dn = record.get("spring.security.ldap.dn").get(0);
            List<String> roleValues = record.get(this.getGroupRoleAttribute());
            HashSet<String> roles = new HashSet<String>();
            if (roleValues != null) {
                roles.addAll(roleValues);
            }
            for (String role : roles) {
                if (this.isConvertToUpperCase()) {
                    role = role.toUpperCase(Locale.ROOT);
                }
                circular |= !authorities.add(new LdapAuthority(role = this.getRolePrefix() + role, dn, record));
            }
            String string = roleName = roles.size() > 0 ? (String)roles.iterator().next() : dn;
            if (circular) continue;
            this.performNestedSearch(dn, roleName, authorities, depth - 1);
        }
    }

    private Set<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Set<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    private int getMaxSearchDepth() {
        return this.maxSearchDepth;
    }

    public void setMaxSearchDepth(int maxSearchDepth) {
        this.maxSearchDepth = maxSearchDepth;
    }
}

