/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.WebClientReactiveRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class RefreshTokenReactiveOAuth2AuthorizedClientProvider
implements ReactiveOAuth2AuthorizedClientProvider {
    private ReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient = new WebClientReactiveRefreshTokenTokenResponseClient();
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient == null || authorizedClient.getRefreshToken() == null || !this.hasTokenExpired((OAuth2Token)authorizedClient.getAccessToken())) {
            return Mono.empty();
        }
        Object requestScope = context.getAttribute(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME);
        Set<String> scopes = Collections.emptySet();
        if (requestScope != null) {
            Assert.isInstanceOf(String[].class, requestScope, (String)("The context attribute must be of type String[] '" + OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME + "'"));
            scopes = new HashSet<String>(Arrays.asList((String[])requestScope));
        }
        ClientRegistration clientRegistration = context.getClientRegistration();
        OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest = new OAuth2RefreshTokenGrantRequest(clientRegistration, authorizedClient.getAccessToken(), authorizedClient.getRefreshToken(), scopes);
        return Mono.just((Object)refreshTokenGrantRequest).flatMap(this.accessTokenResponseClient::getTokenResponse).onErrorMap(OAuth2AuthorizationException.class, e -> new ClientAuthorizationException(e.getError(), clientRegistration.getRegistrationId(), (Throwable)e)).map(tokenResponse -> new OAuth2AuthorizedClient(clientRegistration, context.getPrincipal().getName(), tokenResponse.getAccessToken(), tokenResponse.getRefreshToken()));
    }

    private boolean hasTokenExpired(OAuth2Token token) {
        return this.clock.instant().isAfter(token.getExpiresAt().minus(this.clockSkew));
    }

    public void setAccessTokenResponseClient(ReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

