/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.runtime.AsnBitString;
import org.jzkit.a2j.codec.runtime.BERInputStream;
import org.jzkit.a2j.codec.runtime.BEROutputStream;
import org.jzkit.a2j.codec.runtime.SerializationManager;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.AccessControlRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Close_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DeleteResultSetRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Entry_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ExtendedServicesRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ListEntries_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_codec;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ResourceControlRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ResourceReportRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Segment_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SortRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.TermInfo_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Term_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.TriggerResourceControlRequest_type;
import org.jzkit.z3950.util.APDUEvent;
import org.jzkit.z3950.util.APDUObservable;
import org.jzkit.z3950.util.TermInformation;
import org.jzkit.z3950.util.Z3950Constants;

public class ZTargetEndpoint
extends Thread {
    private Socket z_assoc = null;
    private InputStream incoming_data = null;
    private OutputStream outgoing_data = null;
    private PDU_codec codec = PDU_codec.getCodec();
    private OIDRegister reg = null;
    private boolean running = true;
    public APDUObservable pdu_announcer = new APDUObservable();
    private String charset_encoding = "US-ASCII";
    private Properties props = null;
    private Logger log = Logger.getLogger(ZTargetEndpoint.class.getName());
    public static final String US_ASCII_ENCODING = "US-ASCII";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String UTF_16_ENCODING = "UTF-16";
    public static Properties default_props = new Properties();

    public ZTargetEndpoint(Socket s, Properties p, OIDRegister reg) {
        this.props = p;
        this.reg = reg;
    }

    public ZTargetEndpoint(Socket s, OIDRegister reg) {
        this.z_assoc = s;
        this.props = default_props;
        this.reg = reg;
        try {
            this.incoming_data = s.getInputStream();
            this.outgoing_data = s.getOutputStream();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error constructing TargetEndpoint", e);
        }
    }

    protected void finalize() {
    }

    protected void notifyAPDUEvent(PDU_type pdu) {
        this.log.fine("notifyAPDUEvent(...)");
        byte[] refid = null;
        switch (pdu.which) {
            case 0: {
                refid = ((InitializeRequest_type)pdu.o).referenceId;
                break;
            }
            case 2: {
                refid = ((SearchRequest_type)pdu.o).referenceId;
                break;
            }
            case 4: {
                refid = ((PresentRequest_type)pdu.o).referenceId;
                break;
            }
            case 6: {
                refid = ((DeleteResultSetRequest_type)pdu.o).referenceId;
                break;
            }
            case 9: {
                refid = ((AccessControlRequest_type)pdu.o).referenceId;
                break;
            }
            case 10: {
                refid = ((ResourceControlRequest_type)pdu.o).referenceId;
                break;
            }
            case 12: {
                refid = ((TriggerResourceControlRequest_type)pdu.o).referenceId;
                break;
            }
            case 13: {
                refid = ((ResourceReportRequest_type)pdu.o).referenceId;
                break;
            }
            case 15: {
                refid = ((ScanRequest_type)pdu.o).referenceId;
                break;
            }
            case 17: {
                refid = ((SortRequest_type)pdu.o).referenceId;
                break;
            }
            case 19: {
                refid = ((Segment_type)pdu.o).referenceId;
                break;
            }
            case 20: {
                refid = ((ExtendedServicesRequest_type)pdu.o).referenceId;
                break;
            }
            case 22: {
                refid = ((Close_type)pdu.o).referenceId;
                break;
            }
        }
        APDUEvent e = new APDUEvent(this, pdu, refid != null ? new String(refid) : null);
        this.pdu_announcer.setChanged();
        this.pdu_announcer.notifyObservers(e);
    }

    public void sendInitResponse(byte[] refid, AsnBitString protocol_version, AsnBitString options, long pref_message_size, long exceptional_record_size, boolean result, String implementation_id, String implementation_name, String implementation_version, EXTERNAL_type user_information, ArrayList other_information) throws IOException {
        PDU_type pdu = new PDU_type();
        InitializeResponse_type initialize_response = new InitializeResponse_type();
        pdu.o = initialize_response;
        pdu.which = 1;
        initialize_response.referenceId = refid;
        initialize_response.protocolVersion = protocol_version;
        initialize_response.options = options;
        initialize_response.preferredMessageSize = BigInteger.valueOf(pref_message_size);
        initialize_response.exceptionalRecordSize = BigInteger.valueOf(exceptional_record_size);
        initialize_response.result = new Boolean(result);
        initialize_response.implementationId = implementation_id;
        initialize_response.implementationName = implementation_name;
        initialize_response.implementationVersion = implementation_version;
        initialize_response.userInformationField = user_information;
        initialize_response.otherInfo = other_information;
        this.encodeAndSend(pdu);
    }

    public void sendSearchResponse(Boolean search_status, int result_set_status, int result_set_size, int number_of_records_returned, int next_result_set_position) throws IOException {
        PDU_type pdu = new PDU_type();
        SearchResponse_type search_response = new SearchResponse_type();
        pdu.o = search_response;
        pdu.which = 3;
        search_response.resultCount = BigInteger.valueOf(result_set_size);
        search_response.numberOfRecordsReturned = BigInteger.valueOf(number_of_records_returned);
        search_response.nextResultSetPosition = BigInteger.valueOf(next_result_set_position);
        search_response.searchStatus = search_status;
        if (search_status.equals(Boolean.FALSE)) {
            search_response.resultSetStatus = BigInteger.valueOf(result_set_status);
        }
        search_response.presentStatus = BigInteger.valueOf(0L);
        search_response.records = new Records_type();
        search_response.records.which = 0;
        search_response.records.o = new ArrayList();
        this.encodeAndSend(pdu);
    }

    public void sendScanResponse(byte[] refid, BigInteger step_size, BigInteger scan_status, BigInteger position_of_term, List scan_result, int[] attrset, Object additional) throws IOException {
        PDU_type pdu = new PDU_type();
        ScanResponse_type scan_response = new ScanResponse_type();
        pdu.o = scan_response;
        pdu.which = 16;
        scan_response.referenceId = refid;
        scan_response.stepSize = step_size;
        scan_response.scanStatus = scan_status;
        scan_response.numberOfEntriesReturned = scan_result != null ? BigInteger.valueOf(scan_result.size()) : BigInteger.valueOf(0L);
        scan_response.positionOfTerm = position_of_term;
        scan_response.attributeSet = attrset;
        scan_response.otherInfo = null;
        scan_response.entries = new ListEntries_type();
        scan_response.entries.nonsurrogateDiagnostics = null;
        scan_response.entries.entries = new ArrayList();
        if (scan_result != null) {
            for (TermInformation ir_term_info : scan_result) {
                Entry_type et = new Entry_type();
                et.which = 0;
                TermInfo_type term_info = new TermInfo_type();
                et.o = term_info;
                term_info.term = new Term_type();
                term_info.term.which = 0;
                term_info.term.o = ir_term_info.the_term.getBytes();
                term_info.globalOccurrences = BigInteger.valueOf(ir_term_info.number_of_occurences);
                scan_response.entries.entries.add(et);
            }
        }
        this.encodeAndSend(pdu);
    }

    public void sendClose(int reason_code, String reason_text) throws IOException {
        PDU_type pdu = new PDU_type();
        pdu.which = 22;
        Close_type close = new Close_type();
        pdu.o = close;
        close.closeReason = BigInteger.valueOf(reason_code);
        close.diagnosticInformation = reason_text;
        this.encodeAndSend(pdu);
    }

    public void notifyClose() {
        PDU_type pdu = new PDU_type();
        pdu.which = 22;
        Close_type close = new Close_type();
        pdu.o = close;
        close.closeReason = Z3950Constants.CLOSE_REASON_TIMEOUT;
        close.diagnosticInformation = "Internal close notification";
        this.notifyAPDUEvent(pdu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAndSend(PDU_type the_pdu) throws IOException {
        this.log.fine("encodeAndSend(...)");
        ZTargetEndpoint zTargetEndpoint = this;
        synchronized (zTargetEndpoint) {
            BEROutputStream encoder = new BEROutputStream(this.charset_encoding, this.reg);
            this.codec.serialize((SerializationManager)encoder, the_pdu, false, "PDU");
            encoder.flush();
            encoder.writeTo(this.outgoing_data);
            this.outgoing_data.flush();
        }
        ZTargetEndpoint.yield();
    }

    public void shutdown() {
        this.log.fine("shutdown()");
        this.running = false;
        try {
            this.interrupt();
        }
        catch (SecurityException se) {
            this.log.log(Level.SEVERE, "shutdown", se);
        }
    }

    public void run() {
        while (this.running) {
            try {
                this.log.fine("Waiting for pdu on input stream");
                BERInputStream bds = new BERInputStream(this.incoming_data, this.charset_encoding, this.reg);
                PDU_type pdu = null;
                pdu = (PDU_type)this.codec.serialize((SerializationManager)bds, pdu, false, "PDU");
                this.notifyAPDUEvent(pdu);
                ZTargetEndpoint.yield();
            }
            catch (InterruptedIOException iioe) {
                this.log.log(Level.SEVERE, "Processing java.io.InterruptedIOException, shut down association", iioe);
                this.running = false;
                try {
                    this.sendClose(0, "Session Timeout");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.notifyClose();
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Connection Closed")) {
                    this.log.fine("Connection Closed");
                } else {
                    this.log.log(Level.SEVERE, "Processing java.io.IOException, shut down association", ioe);
                }
                this.running = false;
                this.notifyClose();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Processing exception : ", e);
                e.printStackTrace();
                this.running = false;
            }
        }
        this.log.fine("Assoc thread exiting (number of listeners=" + this.pdu_announcer.countObservers() + ")");
        try {
            this.incoming_data.close();
            this.outgoing_data.close();
            this.z_assoc.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Exception closing open sockets", e);
        }
        this.incoming_data = null;
        this.outgoing_data = null;
        this.z_assoc = null;
        this.pdu_announcer.deleteObservers();
        this.pdu_announcer = null;
    }

    public Observable getPDUAnnouncer() {
        return this.pdu_announcer;
    }

    public String getCharsetEncoding() {
        return this.charset_encoding;
    }

    public void setCharsetEncoding(String enc) {
        this.charset_encoding = enc;
    }

    static {
        default_props.setProperty("ImplementationId", "174");
        default_props.setProperty("ImplementationName", "K-Int Generic Z Server");
        default_props.setProperty("ImplementationVersion", "1.0");
    }
}

