/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.RecordModel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.z3950.RecordModel.Z3950RetrievalRecord;
import org.jzkit.z3950.gen.v3.RecordSyntax_generic.TaggedElement_type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GRS1
implements InformationFragment,
Serializable,
Z3950RetrievalRecord {
    private String source_repository = null;
    private String source_collection_name = null;
    private String orig_schema = null;
    private Object handle = null;
    private ArrayList root_node = null;
    private Document record_as_dom = null;
    private OIDRegister reg = null;
    private ExplicitRecordFormatSpecification spec = null;
    private static transient DocumentBuilderFactory dfactory = null;
    private Map additional_info = new HashMap();
    private long hit_no;

    public GRS1(String source_repository, String source_collection_name, Object handle, Object root_node, ExplicitRecordFormatSpecification spec, OIDRegister reg) {
        this.source_repository = source_repository;
        this.source_collection_name = source_collection_name;
        this.handle = null;
        this.root_node = (ArrayList)root_node;
        this.spec = spec;
        this.reg = reg;
    }

    public Object getOriginalObject() {
        return this.root_node;
    }

    public String getOriginalObjectClassName() {
        return "java.util.ArrayList";
    }

    public Document getDocument() {
        if (this.record_as_dom == null) {
            try {
                DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                this.record_as_dom = docBuilder.newDocument();
                Element root = this.record_as_dom.createElement("grs");
                this.record_as_dom.appendChild(root);
                this.convert(this.record_as_dom, root, this.root_node);
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        }
        return this.record_as_dom;
    }

    public String getDocumentSchema() {
        if (this.record_as_dom == null) {
            this.getDocument();
        }
        if (this.orig_schema == null) {
            this.orig_schema = "grs-1";
        }
        return this.orig_schema;
    }

    public String getSourceRepositoryID() {
        return this.source_repository;
    }

    public String getSourceCollectionName() {
        return this.source_collection_name;
    }

    public Object getSourceFragmentID() {
        if (this.handle != null) {
            return this.handle;
        }
        return null;
    }

    private void convert(Document doc, Element parent, ArrayList nodes) {
        block10: for (TaggedElement_type elem : nodes) {
            Element tag_element = doc.createElement("GRSTag");
            parent.appendChild(tag_element);
            tag_element.setAttribute("type", elem.tagType.toString());
            tag_element.setAttribute("value", elem.tagValue.o.toString());
            if (elem.tagOccurrence != null) {
                tag_element.setAttribute("occurence", elem.tagOccurrence.toString());
            }
            switch (elem.content.which) {
                case 6: {
                    if (this.orig_schema != null || !elem.tagType.toString().equals("1") || !elem.tagValue.o.toString().equals("1")) break;
                    int[] oid = (int[])elem.content.o;
                    OIDRegisterEntry entry = this.reg.lookupByOID(oid);
                    if (entry == null) continue block10;
                    this.orig_schema = entry.getName();
                    break;
                }
                case 0: {
                    tag_element.appendChild(doc.createTextNode(new String((byte[])elem.content.o)));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    tag_element.appendChild(doc.createTextNode(elem.content.o.toString()));
                    break;
                }
                case 8: {
                    tag_element.appendChild(doc.createTextNode("Element not there"));
                    break;
                }
                case 9: {
                    tag_element.appendChild(doc.createTextNode("Element empty"));
                    break;
                }
                case 10: {
                    tag_element.appendChild(doc.createTextNode("No data requested"));
                    break;
                }
                case 11: {
                    tag_element.appendChild(doc.createTextNode("GRS Diagnostic"));
                    break;
                }
                case 12: {
                    this.convert(doc, tag_element, (ArrayList)elem.content.o);
                }
            }
        }
    }

    public ExplicitRecordFormatSpecification getFormatSpecification() {
        return this.spec;
    }

    public void setFormatSpecification(ExplicitRecordFormatSpecification spec) {
        this.spec = spec;
    }

    public void setSourceRepositoryID(String id) {
        this.source_repository = id;
    }

    public void setSourceCollectionName(String collection_name) {
        this.source_collection_name = collection_name;
    }

    public void setSourceFragmentID(Object id) {
        this.handle = id;
    }

    public EXTERNAL_type getRecordEncoding() {
        return null;
    }

    public Map getExtendedInfo() {
        return this.additional_info;
    }

    public long getHitNo() {
        return this.hit_no;
    }

    public void setHitNo(long hit_no) {
        this.hit_no = hit_no;
    }

    static {
        dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(false);
        dfactory.setAttribute("http://xml.org/sax/features/validation", Boolean.FALSE);
        dfactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
    }
}

