/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;

public class XsdHttpHandler
extends URIHandlerImpl {
    private final HTTPClient client;
    private Collection<HTTPResponse> responses = new LinkedList<HTTPResponse>();

    public XsdHttpHandler(HTTPClient client) {
        this.client = client;
    }

    public boolean canHandle(URI uri) {
        return "http".equals(uri.scheme()) || "https".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        HTTPResponse httpResponse = this.client.get(new URL(uri.toString()));
        this.responses.add(httpResponse);
        InputStream result = httpResponse.getResponseStream();
        return result;
    }

    public void dispose() {
        this.responses.forEach(r -> r.dispose());
    }
}

