/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.data.wfs.internal.ComplexGetFeatureResponse;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.util.logging.Logging;

public class WFSContentComplexFeatureCollection
extends BaseFeatureCollection<FeatureType, Feature> {
    private static final Logger LOGGER = Logging.getLogger(WFSContentComplexFeatureCollection.class);
    private final WFSClient client;
    private final FeatureType schema;
    private final GetFeatureRequest request;
    private final QName name;
    private final Filter filter;

    public WFSContentComplexFeatureCollection(GetFeatureRequest request, FeatureType schema, QName name, WFSClient client) {
        this(request, schema, name, null, client);
    }

    public WFSContentComplexFeatureCollection(GetFeatureRequest request, FeatureType schema, QName name, Filter filter, WFSClient client) {
        Objects.requireNonNull(client);
        this.request = request;
        this.name = name;
        this.schema = schema;
        this.client = client;
        this.filter = filter;
    }

    public FeatureIterator<Feature> features() {
        try {
            ComplexGetFeatureResponse response = this.client.issueComplexRequest(this.request);
            response.getParser().setFilter(this.filter);
            return response.features();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException("Couldn't read features of collection.", e);
        }
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        return new WFSContentComplexFeatureCollection(this.request, this.schema, this.name, filter, this.client);
    }
}

