/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataFileUpload_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.springframework.data.jpa.domain.Specification;

public class MetadataFileUploadSpecs {
    private MetadataFileUploadSpecs() {
    }

    public static Specification<MetadataFileUpload> hasId(final int id) {
        return new Specification<MetadataFileUpload>(){

            public Predicate toPredicate(Root<MetadataFileUpload> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path updloadIdAttributePath = root.get(MetadataFileUpload_.id);
                Predicate pdloadIdEqualPredicate = cb.equal((Expression)updloadIdAttributePath, cb.literal((Object)id));
                return pdloadIdEqualPredicate;
            }
        };
    }

    public static Specification<MetadataFileUpload> hasMetadataId(final int id) {
        return new Specification<MetadataFileUpload>(){

            public Predicate toPredicate(Root<MetadataFileUpload> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path updloadIdAttributePath = root.get(MetadataFileUpload_.metadataId);
                Predicate pdloadIdEqualPredicate = cb.equal((Expression)updloadIdAttributePath, cb.literal((Object)id));
                return pdloadIdEqualPredicate;
            }
        };
    }

    public static Specification<MetadataFileUpload> uploadDateBetweenAndByGroups(final ISODate uploadFrom, final ISODate uploadTo, final Collection<Integer> groups) {
        return new Specification<MetadataFileUpload>(){

            public Predicate toPredicate(Root<MetadataFileUpload> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path uploadDateAttributePath = root.get(MetadataFileUpload_.uploadDate);
                Path metadataIdAttributePath = root.get(MetadataFileUpload_.metadataId);
                Predicate uploadDateBetweenPredicate = cb.between((Expression)uploadDateAttributePath, (Comparable)((Object)uploadFrom.toString()), (Comparable)((Object)uploadTo.toString()));
                if (!groups.isEmpty()) {
                    Root metadataRoot = query.from(Metadata.class);
                    Path groupOwnerPath = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner);
                    Predicate inGroups = groupOwnerPath.in(groups);
                    uploadDateBetweenPredicate = cb.and((Expression)cb.equal((Expression)metadataRoot.get(Metadata_.id), (Expression)metadataIdAttributePath), (Expression)cb.and((Expression)uploadDateBetweenPredicate, (Expression)inGroups));
                }
                return uploadDateBetweenPredicate;
            }
        };
    }

    public static Specification<MetadataFileUpload> isNotDeleted() {
        return new Specification<MetadataFileUpload>(){

            public Predicate toPredicate(Root<MetadataFileUpload> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path deletedDateAttributePath = root.get(MetadataFileUpload_.deletedDate);
                Predicate deletedPredicate = cb.isNull((Expression)deletedDateAttributePath);
                return deletedPredicate;
            }
        };
    }

    public static Specification<MetadataFileUpload> isNotDeletedForMetadata(final int metadataId) {
        return new Specification<MetadataFileUpload>(){

            public Predicate toPredicate(Root<MetadataFileUpload> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path deletedDateAttributePath = root.get(MetadataFileUpload_.deletedDate);
                Path metadataIdAttributePath = root.get(MetadataFileUpload_.metadataId);
                Predicate notDeletedPredicate = cb.and((Expression)cb.isNull((Expression)deletedDateAttributePath), (Expression)cb.equal((Expression)metadataIdAttributePath, (Object)metadataId));
                return notDeletedPredicate;
            }
        };
    }
}

